/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.binding.soap.SOAPMessageMarshaller;
import org.jboss.ws.binding.soap.SOAPMessageUnMarshaller;
import org.jboss.ws.soap.EndpointInfo;
import org.w3c.dom.Node;

public class SOAPConnectionImpl
extends SOAPConnection {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$soap$SOAPConnectionImpl == null ? (class$org$jboss$ws$soap$SOAPConnectionImpl = SOAPConnectionImpl.class$("org.jboss.ws.soap.SOAPConnectionImpl")) : class$org$jboss$ws$soap$SOAPConnectionImpl));
    boolean closed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$soap$SOAPConnectionImpl;

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        return this.call(reqMessage, endpoint, false);
    }

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws SOAPException {
        Client remotingClient;
        InvokerLocator locator;
        Map<String, Object> callProperties;
        String targetAddress;
        if (reqMessage == null) {
            throw new IllegalArgumentException("Given SOAPMessage cannot be null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Given endpoint cannot be null");
        }
        if (this.closed) {
            throw new SOAPException("SOAPConnection is already closed");
        }
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
            callProperties = epInfo.getProperties();
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
            callProperties = null;
        } else {
            targetAddress = endpoint.toString();
            callProperties = null;
        }
        try {
            log.debug((Object)("Get locator for: " + endpoint));
            locator = new InvokerLocator(targetAddress);
        }
        catch (MalformedURLException e) {
            throw new SOAPException("Malformed endpoint address", (Throwable)e);
        }
        try {
            remotingClient = new Client(locator, "saaj");
            remotingClient.setMarshaller((Marshaller)new SOAPMessageMarshaller());
            remotingClient.setUnMarshaller((UnMarshaller)(!oneway ? new SOAPMessageUnMarshaller() : null));
        }
        catch (Exception e) {
            throw new SOAPException("Could not setup remoting client", (Throwable)e);
        }
        try {
            Map metadata = this.getRemotingMetaData(reqMessage, targetAddress, callProperties);
            SOAPEnvelope soapReqEnv = reqMessage.getSOAPPart().getEnvelope();
            String envStr = DOMWriter.printNode((Node)soapReqEnv, (boolean)true);
            log.debug((Object)("Remoting meta data: " + metadata));
            log.debug((Object)("Outgoing SOAPMessage\n" + envStr));
            SOAPMessage resMessage = null;
            if (oneway) {
                remotingClient.invokeOneway((Object)reqMessage, metadata, false);
            } else {
                resMessage = (SOAPMessage)remotingClient.invoke((Object)reqMessage, metadata);
            }
            if (resMessage != null) {
                SOAPEnvelope soapResEnv = resMessage.getSOAPPart().getEnvelope();
                String envStr2 = DOMWriter.printNode((Node)soapResEnv, (boolean)true);
                log.debug((Object)("Incomming Response SOAPMessage\n" + envStr2));
            }
            return resMessage;
        }
        catch (Throwable t) {
            throw new SOAPException("Could not transmit message", t);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException("SOAPConnection is already closed");
        }
        this.closed = true;
    }

    private Map getRemotingMetaData(SOAPMessage reqMessage, String targetAddress, Map callProperties) throws SOAPException {
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        String[] action = mimeHeaders.getHeader("SOAPAction");
        if (action != null && action.length > 0) {
            String soapAction = action[0];
            if (!soapAction.startsWith("\"")) {
                soapAction = "\"" + soapAction;
            }
            if (!soapAction.endsWith("\"")) {
                soapAction = String.valueOf(soapAction) + "\"";
            }
            mimeHeaders.setHeader("SOAPAction", soapAction);
        } else {
            mimeHeaders.setHeader("SOAPAction", "\"\"");
        }
        if (reqMessage.saveRequired()) {
            reqMessage.saveChanges();
        }
        HashMap<String, Properties> metadata = new HashMap<String, Properties>();
        Properties props = new Properties();
        metadata.put("HEADER", props);
        Iterator i = mimeHeaders.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader header = (MimeHeader)i.next();
            String currentValue = props.getProperty(header.getName());
            if (currentValue != null) {
                props.put(header.getName(), String.valueOf(currentValue) + "," + header.getValue());
                continue;
            }
            props.put(header.getName(), header.getValue());
        }
        if (callProperties != null) {
            Iterator it = callProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (key.equals("javax.xml.rpc.security.auth.username")) {
                    metadata.put("http.basic.username", (Properties)val);
                }
                if (!key.equals("javax.xml.rpc.security.auth.password")) continue;
                metadata.put("http.basic.password", (Properties)val);
            }
        }
        return metadata;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

