/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.soap.AttrImpl;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.NodeImpl;
import org.jboss.ws.soap.NodeListImpl;
import org.jboss.ws.soap.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class SOAPElementImpl
extends NodeImpl
implements SOAPElement {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$soap$SOAPElementImpl == null ? (class$org$jboss$ws$soap$SOAPElementImpl = SOAPElementImpl.class$("org.jboss.ws.soap.SOAPElementImpl")) : class$org$jboss$ws$soap$SOAPElementImpl));
    private Element element = (Element)this.domNode;
    private String encodingStyle = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$soap$SOAPElementImpl;

    public SOAPElementImpl(String localPart) {
        super(DOMUtils.createElement((String)localPart));
        log.trace((Object)("new SOAPElementImpl: " + this.getElementName()));
    }

    public SOAPElementImpl(String localPart, String prefix, String nsURI) {
        super(DOMUtils.createElement((String)localPart, (String)prefix, (String)nsURI));
        log.trace((Object)("new SOAPElementImpl: " + this.getElementName()));
    }

    public SOAPElementImpl(Name name) {
        this(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    protected SOAPElementImpl(SOAPElementImpl element) {
        super(element);
        log.trace((Object)("new SOAPElementImpl: " + this.getElementName()));
    }

    public SOAPEnvelope getSOAPEnvelope() {
        SOAPElementImpl soapElement = this;
        while (soapElement != null && !(soapElement instanceof SOAPEnvelope)) {
            soapElement = soapElement.getParentElement();
        }
        return (SOAPEnvelope)soapElement;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if ("xml".equals(name.getPrefix())) {
            this.setAttribute(name.getQualifiedName(), value);
        } else {
            this.setAttributeNS(name.getURI(), name.getQualifiedName(), value);
        }
        return this;
    }

    public SOAPElement addChildElement(String name) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(name);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String nsURI = this.getNamespaceURI(prefix);
        if (nsURI == null) {
            throw new IllegalArgumentException("Cannot obtain namespace URI for prefix: " + prefix);
        }
        SOAPElementImpl soapElement = new SOAPElementImpl(localName, prefix, nsURI);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(localName, prefix, uri);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(name);
        soapElement = this.addChildElement(soapElement);
        return soapElement;
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        log.trace((Object)("addChildElement: " + this.getElementName() + " -> " + child.getElementName()));
        SOAPElementImpl soapElement = (SOAPElementImpl)child;
        soapElement = (SOAPElementImpl)((Object)this.appendChild((Node)((Object)soapElement)));
        return soapElement.completeNamespaceDeclaration();
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String nsURI) {
        if (prefix == null) {
            throw new IllegalArgumentException("Invalid 'null' prefix");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Invalid empty prefix");
        }
        if (nsURI == null) {
            throw new IllegalArgumentException("Invalid 'null' namespace URI");
        }
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("Invalid empty namespace URI");
        }
        log.trace((Object)("addNamespaceDeclaration: xmlns:" + prefix + "='" + nsURI + "'"));
        this.element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        return this;
    }

    private SOAPElement completeNamespaceDeclaration() {
        String prevNS;
        String prefix = this.getPrefix();
        String nsURI = this.getNamespaceURI();
        if (prefix != null && nsURI != null && !nsURI.equals(prevNS = this.getNamespaceURI(prefix))) {
            this.addNamespaceDeclaration(prefix, nsURI);
        }
        return this;
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        log.trace((Object)("addTextNode: " + value));
        Text domText = this.element.getOwnerDocument().createTextNode(value);
        TextImpl soapText = new TextImpl(domText);
        this.appendChild((Node)((Object)soapText));
        return this;
    }

    public Iterator getAllAttributes() {
        ArrayList<NameImpl> list = new ArrayList<NameImpl>();
        NamedNodeMap nnm = this.getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            Node node = nnm.item(i);
            String local = node.getLocalName();
            String prefix = node.getPrefix();
            String uri = node.getNamespaceURI();
            list.add(new NameImpl(local, prefix, uri));
            ++i;
        }
        return list.iterator();
    }

    public String getAttributeValue(Name name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null ? attr.getValue() : null;
    }

    private Attr getAttributeNode(Name name) {
        Attr attr = null;
        String nsURI = name.getURI();
        attr = nsURI.length() > 0 ? this.element.getAttributeNodeNS(nsURI, name.getLocalName()) : this.element.getAttributeNode(name.getLocalName());
        return attr;
    }

    public Iterator getChildElements() {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = this.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1 || nodeType == 3) {
                list.add(node);
            }
            ++i;
        }
        return list.iterator();
    }

    public Iterator getChildElements(Name name) {
        ArrayList<SOAPElement> list = new ArrayList<SOAPElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPElement el;
            Object elementOrTextNode = it.next();
            if (!(elementOrTextNode instanceof SOAPElement) || !(el = (SOAPElement)elementOrTextNode).getElementName().equals(name)) continue;
            list.add(el);
        }
        return list.iterator();
    }

    public Name getElementName() {
        String nsURI = this.element.getNamespaceURI();
        if (nsURI != null && nsURI.length() > 0) {
            String prefix = this.element.getPrefix();
            String localName = this.element.getLocalName();
            return new NameImpl(localName, prefix, nsURI);
        }
        String nodeName = this.element.getNodeName();
        return new NameImpl(nodeName);
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public Iterator getNamespacePrefixes() {
        ArrayList list = this.getNamespacePrefixList();
        return list.iterator();
    }

    private ArrayList getNamespacePrefixList() {
        ArrayList<String> list = new ArrayList<String>();
        NamedNodeMap attrMap = this.element.getAttributes();
        int i = 0;
        while (i < attrMap.getLength()) {
            Attr attr = (Attr)attrMap.item(i);
            String attrName = attr.getNodeName();
            if (attrName.startsWith("xmlns:")) {
                list.add(attrName.substring(6));
            }
            ++i;
        }
        return list;
    }

    public String getNamespaceURI(String prefix) {
        String nsURI = this.element.getAttribute("xmlns:" + prefix);
        if (nsURI.length() == 0 && this.getParentElement() != null) {
            return this.getParentElement().getNamespaceURI(prefix);
        }
        return nsURI.length() > 0 ? nsURI : null;
    }

    public Iterator getVisibleNamespacePrefixes() {
        ArrayList list = this.getNamespacePrefixList();
        SOAPElementImpl parent = (SOAPElementImpl)this.getParentElement();
        while (parent != null) {
            list.addAll(parent.getNamespacePrefixList());
            parent = (SOAPElementImpl)parent.getParentElement();
        }
        return list.iterator();
    }

    public boolean removeAttribute(Name name) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            this.element.removeAttributeNode(attr);
            return true;
        }
        return false;
    }

    public void removeContents() {
        log.trace((Object)"removeContents");
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPElement el = (SOAPElement)it.next();
            el.detachNode();
        }
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        boolean ret = this.getAttributeNode("xmlns:" + prefix) != null;
        this.removeAttribute("xmlns:" + prefix);
        return ret;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (!"".equals(encodingStyle) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle)) {
            throw new IllegalArgumentException("Unsupported encodingStyle: " + encodingStyle);
        }
        this.encodingStyle = encodingStyle;
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public void removeAttribute(String name) throws DOMException {
        this.element.removeAttribute(name);
    }

    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.element.removeAttributeNS(namespaceURI, localName);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.element.setAttribute(name, value);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.element.hasAttributeNS(namespaceURI, localName);
    }

    public Attr getAttributeNode(String name) {
        Attr attr = this.element.getAttributeNode(name);
        return attr == null ? null : new AttrImpl(this, attr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return this.element.removeAttributeNode(oldAttr);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.element.setAttributeNode(newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.element.setAttributeNodeNS(newAttr);
    }

    public NodeList getElementsByTagName(String name) {
        return new NodeListImpl(DOMUtils.getChildElements((Node)((Object)this), (String)name));
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.element.getAttributeNS(namespaceURI, localName);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.element.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        Attr attr = this.element.getAttributeNodeNS(namespaceURI, localName);
        return attr == null ? null : new AttrImpl(this, attr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new NodeListImpl(DOMUtils.getChildElements((Node)((Object)this), (QName)new QName(namespaceURI, localName)));
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new NotImplementedException("getSchemaTypeInfo");
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new NotImplementedException("setIdAttribute");
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new NotImplementedException("setIdAttributeNode");
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new NotImplementedException("setIdAttributeNS");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

