/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.soap.DetailImpl;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPFactoryImpl
extends SOAPFactory {
    public SOAPElement createElement(Name name) throws SOAPException {
        return new SOAPElementImpl(name);
    }

    public SOAPElement createElement(String localName) throws SOAPException {
        return new SOAPElementImpl(localName);
    }

    public SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        return new SOAPElementImpl(localName, prefix, uri);
    }

    public SOAPElementImpl createElement(Element domElement, boolean deep) throws SOAPException {
        SOAPElementImpl soapElement = new SOAPElementImpl(domElement.getLocalName(), domElement.getPrefix(), domElement.getNamespaceURI());
        if (deep) {
            DOMUtils.copyAttributes((Element)((Object)soapElement), (Element)domElement);
            NodeList nlist = domElement.getChildNodes();
            int i = 0;
            while (i < nlist.getLength()) {
                Node child = nlist.item(i);
                if (child.getNodeType() == 1) {
                    soapElement.addChildElement(this.createElement((Element)child, true));
                } else if (child.getNodeType() == 3) {
                    soapElement.addTextNode(child.getNodeValue());
                }
                ++i;
            }
        }
        return soapElement;
    }

    public Detail createDetail() throws SOAPException {
        return new DetailImpl();
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }
}

