/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ServiceDesc;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.xb.binding.NamespaceRegistry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContextImpl
implements SOAPMessageContext {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$soap$SOAPMessageContextImpl == null ? (class$org$jboss$ws$soap$SOAPMessageContextImpl = SOAPMessageContextImpl.class$("org.jboss.ws.soap.SOAPMessageContextImpl")) : class$org$jboss$ws$soap$SOAPMessageContextImpl));
    private SOAPMessage soapMessage;
    private ServiceDesc serviceDesc;
    private EndpointMetaData epMetaData;
    private OperationMetaData opMetaData;
    private SerializationContextImpl serContext;
    private Properties properties = new Properties();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$soap$SOAPMessageContextImpl;

    public SOAPMessage getMessage() {
        return this.soapMessage;
    }

    public void setMessage(SOAPMessage message) {
        this.soapMessage = message;
    }

    public String[] getRoles() {
        return new String[0];
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setProperties(Map<String, Object> props) {
        this.properties.putAll(props);
    }

    public ServiceDesc getServiceDesc() {
        if (this.serviceDesc == null && this.opMetaData != null) {
            log.debug((Object)"Using default service description");
            this.serviceDesc = new ServiceDesc(this.opMetaData.getEndpointMetaData().getServiceMetaData());
        }
        return this.serviceDesc;
    }

    public void setServiceDesc(ServiceDesc serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null && this.opMetaData != null) {
            this.epMetaData = this.opMetaData.getEndpointMetaData();
        }
        return this.epMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public SerializationContextImpl getSerializationContext() {
        if (this.serContext == null) {
            ServiceDesc serviceDesc = this.getServiceDesc();
            ServiceMetaData serviceMetaData = serviceDesc.getServiceMetaData();
            this.serContext = new SerializationContextImpl();
            this.serContext.setTypeMapping(serviceDesc.getTypeMapping());
            this.serContext.setJavaWsdlMapping(serviceMetaData.getJavaWsdlMapping());
        }
        this.serContext.setNamespaceRegistry(this.getNamespaceRegistry());
        return this.serContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (this.soapMessage == null) {
            throw new WSException("Cannot obtain NamespaceRegistry, because there is no SOAPMessage associated with this context");
        }
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)this.soapMessage.getSOAPPart().getEnvelope();
            NamespaceRegistry nsRegistry = soapEnv.getNamespaceRegistry();
            return nsRegistry;
        }
        catch (SOAPException e) {
            throw new WSException(new StringBuffer("Cannot get SOAPEnvelope: ").append((Object)e).toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

