/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageDataContentHandler
extends Component
implements DataContentHandler {
    private static DataFlavor[] flavors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$java$awt$Image;

    static {
        ImageDataContentHandler.buildFlavors();
        ImageIO.setUseCache(false);
    }

    private static void buildFlavors() {
        String[] mimeTypes = ImageIO.getReaderMIMETypes();
        if (mimeTypes == null) {
            return;
        }
        flavors = new DataFlavor[mimeTypes.length];
        int i = 0;
        while (i < mimeTypes.length) {
            ImageDataContentHandler.flavors[i] = new ActivationDataFlavor(class$java$awt$Image == null ? ImageDataContentHandler.class$("java.awt.Image") : class$java$awt$Image, mimeTypes[i], "Image");
            ++i;
        }
    }

    private static ImageWriter getImageWriter(String mimeType) {
        Iterator<ImageWriter> i = ImageIO.getImageWritersByMIMEType(mimeType);
        if (!i.hasNext()) {
            return null;
        }
        return i.next();
    }

    private BufferedImage getBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            BufferedImage buffered = new BufferedImage(image.getHeight(null), image.getWidth(null), 1);
            Graphics2D gfx = buffered.createGraphics();
            gfx.drawImage(image, 0, 0, null);
            return buffered;
        }
        catch (InterruptedException e) {
            throw new IOException("Could not convert image " + e.getMessage());
        }
    }

    public Object getContent(DataSource ds) throws IOException {
        return ImageIO.read(ds.getInputStream());
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
        return this.getContent(ds);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj == null) {
            throw new IOException("Cannot write null source object");
        }
        if (!(obj instanceof Image)) {
            throw new IOException("Requires the source object to be a java.awt.Image but is: " + obj.getClass().getName());
        }
        ImageWriter writer = ImageDataContentHandler.getImageWriter(mimeType);
        if (writer == null) {
            throw new IOException("Image encoding not available for mime type " + mimeType + " on this vm");
        }
        BufferedImage buffered = this.getBufferedImage((Image)obj);
        ImageOutputStream stream = ImageIO.createImageOutputStream(os);
        writer.setOutput(stream);
        writer.write(buffered);
        stream.flush();
        stream.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

