/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import java.util.Arrays;

public class SimpleBoyerMoore {
    private int[] badMatch = new int[256];
    private byte[] pattern;
    public static final int PATTERN_NOT_FOUND = -1;

    public SimpleBoyerMoore(byte[] pattern) {
        this.pattern = pattern;
        this.precomputeBadMatchTable();
    }

    private void precomputeBadMatchTable() {
        Arrays.fill(this.badMatch, this.pattern.length);
        int i = 0;
        while (i < this.pattern.length - 1) {
            this.badMatch[this.pattern[i] & 0xFF] = this.pattern.length - i - 1;
            ++i;
        }
    }

    public int patternSearch(byte[] text, int offset, int length) {
        if (this.pattern.length > length) {
            return -1;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int end = offset + length;
        i = offset + this.pattern.length - 1;
        while (i < end) {
            j = this.pattern.length - 1;
            k = i;
            while (j >= 0 && text[k] == this.pattern[j]) {
                --k;
                --j;
            }
            if (j == -1) {
                return k + 1;
            }
            i += this.badMatch[text[i] & 0xFF];
        }
        return -1;
    }
}

