/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.JavaToXSD;
import org.jboss.ws.tools.helpers.JavaToWSDLHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDL11 {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$tools$JavaToWSDL11 == null ? (class$org$jboss$ws$tools$JavaToWSDL11 = JavaToWSDL11.class$("org.jboss.ws.tools.JavaToWSDL11")) : class$org$jboss$ws$tools$JavaToWSDL11));
    private final String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
    private String wsdlStyle = "RPC/Literal";
    private HashMap<String, Boolean> features = new HashMap();
    private Map<String, String> packageNamespaceMap = null;
    private TypeMapping typeMapping = null;
    private JavaWsdlMapping javaWsdlMapping = null;
    private UnifiedMetaData umd = null;
    private boolean qualifiedElements = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$tools$JavaToWSDL11;

    public JavaToWSDL11() {
        log.debug((Object)"Creating JavaToWSDL11 instance");
    }

    public void addFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public void addFeatures(Map<String, Boolean> map) {
        this.features.putAll(map);
    }

    public boolean getFeature(String name) {
        Boolean val = this.features.get(name);
        if (val != null) {
            return val;
        }
        throw new WSException("Feature unrecognized");
    }

    public void setPackageNamespaceMap(Map<String, String> map) {
        this.packageNamespaceMap = map;
    }

    public TypeMapping getTypeMapping() {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been generated");
        }
        return this.typeMapping;
    }

    public void setUnifiedMetaData(UnifiedMetaData um) {
        this.umd = um;
    }

    public WSDLDefinitions generate(Class endpoint) {
        JBossXSModel schemaModel;
        WSDLDefinitions wsdl = new WSDLDefinitions();
        wsdl.setWsdlNamespace(this.wsdlNamespace);
        if (this.umd != null) {
            JavaToWSDLHelper helper = this.getHelper(this.wsdlStyle, wsdl);
            try {
                helper.setFeatures(this.features);
                JavaToXSD javaToXSD = new JavaToXSD();
                javaToXSD.setPackageNamespaceMap(this.packageNamespaceMap);
                helper.setJavaToXSD(javaToXSD);
                this.handleJavaToWSDLGeneration(helper, endpoint.getName());
                this.typeMapping = helper.getTypeMapping();
            }
            catch (IOException e) {
                log.error((Object)"Error during Java->WSDL generation:", (Throwable)e);
            }
        }
        if (this.qualifiedElements && (schemaModel = wsdl.getWsdlTypes().getSchemaModel()) != null) {
            schemaModel.setQualifiedElements(true);
        }
        return wsdl;
    }

    public void setWSDLStyle(String wsdlStyle) {
        this.wsdlStyle = wsdlStyle;
    }

    public boolean isQualifiedElements() {
        return this.qualifiedElements;
    }

    public void setQualifiedElements(boolean qualifiedElements) {
        this.qualifiedElements = qualifiedElements;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    private void handleJavaToWSDLGeneration(JavaToWSDLHelper helper, String endpointName) throws IOException {
        if (this.umd == null) {
            throw new WSException("Unified Meta Data Model is null");
        }
        List<ServiceMetaData> servicelist = this.umd.getServices();
        block0: for (ServiceMetaData smd : servicelist) {
            List<EndpointMetaData> endpoints = smd.getEndpoints();
            for (EndpointMetaData endpt : endpoints) {
                if (!endpointName.equals(endpt.getServiceEndpointInterfaceName())) continue;
                QName endptName = endpt.getName();
                String intfName = endptName.getLocalPart();
                helper.appendDefinitions(endptName.getNamespaceURI());
                if (intfName.endsWith("Port")) {
                    intfName = intfName.substring(0, intfName.length() - 4);
                }
                List<OperationMetaData> ops = endpt.getOperations();
                for (OperationMetaData op : ops) {
                    List<ParameterMetaData> pmds = op.getParameters();
                    for (ParameterMetaData pmd : pmds) {
                        helper.generateTypesForXSD(pmd);
                    }
                    List<FaultMetaData> fmds = op.getFaults();
                    for (FaultMetaData fmd : fmds) {
                        helper.generateTypesForXSD(fmd);
                    }
                    ParameterMetaData pmd = op.getReturnParameter();
                    if (pmd != null) {
                        helper.generateTypesForXSD(pmd);
                    }
                    helper.generateInterfaces(op, intfName);
                    helper.generateBindings(op, new StringBuffer(String.valueOf(intfName)).append("Binding").toString());
                }
                helper.generateServices(endpt, intfName);
                this.javaWsdlMapping = helper.getJavaWsdlMapping();
                continue block0;
            }
        }
    }

    private JavaToWSDLHelper getHelper(String wsdlStyle, WSDLDefinitions wsdl) {
        JavaToWSDLHelper helper = new JavaToWSDLHelper(wsdl, "http://schemas.xmlsoap.org/wsdl/");
        helper.setWSDLStyle(wsdlStyle);
        return helper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

