/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.tools.Configuration;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class ToolsSchemaConfigReader
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$tools$config$ToolsSchemaConfigReader == null ? (class$org$jboss$ws$tools$config$ToolsSchemaConfigReader = ToolsSchemaConfigReader.class$("org.jboss.ws.tools.config.ToolsSchemaConfigReader")) : class$org$jboss$ws$tools$config$ToolsSchemaConfigReader));
    private URL configLocation = null;
    private Configuration config = new Configuration();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$tools$config$ToolsSchemaConfigReader;

    public Configuration readConfig(String uri) {
        log.trace((Object)("Inside readConfig:uri=" + uri));
        if (uri == null) {
            throw new IllegalArgumentException("URI passed is null");
        }
        try {
            File file = new File(uri);
            this.configLocation = file.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        InputStream is = null;
        try {
            is = this.configLocation.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                unmarshaller.setNamespaceAware(true);
                unmarshaller.setValidation(true);
                unmarshaller.unmarshal(is, (ObjectModelFactory)this, (Object)this.config);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (JBossXBException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.trace((Object)"Exit readConfig");
        return this.config;
    }

    public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        if (root instanceof Configuration) {
            return root;
        }
        return null;
    }

    public Object newChild(Configuration config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace((Object)("Inside newChild:localName=" + localName));
        if ("javaToWSDL".equals(localName)) {
            Configuration.JavaToWSDLConfig j2wsdlc = config.getJavaToWSDLConfig(true);
            return j2wsdlc;
        }
        if ("wsdlToJava".equals(localName)) {
            Configuration.WSDLToJavaConfig wsdl2jc = config.getWSDLToJavaConfig(true);
            String errorStr = "Problem parsing <wsdltojava>";
            wsdl2jc.wsdlLocation = this.getAttribute(navigator, "wsdlLocation", String.valueOf(errorStr) + " attribute=wsdllocation", attrs);
            String disUnwrap = this.getOptionalAttribute(navigator, "disableUnWrap", String.valueOf(errorStr) + " attribute=disableUnwrap", attrs, "false");
            wsdl2jc.disableUnwrap = "true".equalsIgnoreCase(disUnwrap);
            String useAnnotations = this.getOptionalAttribute(navigator, "useJavaAnnotations", String.valueOf(errorStr) + " attribute=disableUnwrap", attrs, "false");
            wsdl2jc.useJavaAnnotations = "true".equalsIgnoreCase(useAnnotations);
            return wsdl2jc;
        }
        if ("global".equals(localName)) {
            Configuration.GlobalConfig globalc = config.getGlobalConfig(true);
            String errorStr = "Problem parsing <global>";
            globalc.nscollide = this.getOptionalAttribute(navigator, "nscollide", String.valueOf(errorStr) + " attribute=nscollide", attrs, "Array");
            return globalc;
        }
        return config;
    }

    public Object newChild(Configuration.JavaToWSDLConfig j2wsdlc, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        String errorStr = "Problem parsing <javatowsdl>";
        if ("service".equals(localName)) {
            String restrictNS;
            errorStr = String.valueOf(errorStr) + "/service ";
            j2wsdlc.serviceName = this.getAttribute(navigator, "name", errorStr, attrs);
            j2wsdlc.endpointName = this.getAttribute(navigator, "endpoint", errorStr, attrs);
            j2wsdlc.wsdlStyle = this.getOptionalAttribute(navigator, "wsdlStyle", errorStr, attrs, "rpc");
            j2wsdlc.wsdlVersion = this.getOptionalAttribute(navigator, "wsdlVersion", errorStr, attrs, "1.1");
            String typesInwsdl = this.getOptionalAttribute(navigator, "includeSchemaInTypes", errorStr, attrs, "true");
            if ("false".equals(typesInwsdl) || "False".equals(typesInwsdl) || "FALSE".equals(typesInwsdl)) {
                j2wsdlc.includeSchemaInWSDL = false;
            }
            if ("true".equalsIgnoreCase(restrictNS = this.getOptionalAttribute(navigator, "restrictSchemaToTargetNS", errorStr, attrs, "false"))) {
                j2wsdlc.restrictSchemaToTargetNS = true;
            }
        } else {
            if ("operation".equals(localName)) {
                errorStr = String.valueOf(errorStr) + "/service/operation";
                return j2wsdlc.createOperationConfig();
            }
            if ("namespaces".equals(localName)) {
                errorStr = String.valueOf(errorStr) + "/namespaces ";
                j2wsdlc.targetNamespace = this.getNamespace(navigator, "targetNamespace", errorStr, attrs);
                j2wsdlc.typeNamespace = this.getNamespace(navigator, "typeNamespace", errorStr, attrs);
                if (j2wsdlc.typeNamespace == null) {
                    j2wsdlc.typeNamespace = j2wsdlc.targetNamespace;
                }
            } else if ("mapping".equals(localName)) {
                errorStr = String.valueOf(errorStr) + "/mapping ";
                j2wsdlc.mappingFileNeeded = true;
                j2wsdlc.mappingFileName = this.getOptionalAttribute(navigator, "fileName", errorStr, attrs, "jaxrpc-mapping.xml");
            } else if ("wsxml".equals(localName)) {
                errorStr = String.valueOf(errorStr) + "/wsxml ";
                j2wsdlc.wsxmlFileNeeded = true;
                j2wsdlc.servletLink = this.getOptionalAttribute(navigator, "servletLink", errorStr, attrs, null);
                j2wsdlc.ejbLink = this.getOptionalAttribute(navigator, "ejbLink", errorStr, attrs, null);
                if (j2wsdlc.ejbLink == null && j2wsdlc.servletLink == null) {
                    throw new WSException("Either servletLink or ejbLink should be specified");
                }
            }
        }
        return j2wsdlc;
    }

    public Object newChild(Configuration.GlobalConfig globalc, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        String errorStr = "Problem parsing <global>";
        if ("package-namespace".equals(localName)) {
            errorStr = String.valueOf(errorStr) + "/package-namespace";
            String pkgname = this.getAttribute(navigator, "package", String.valueOf(errorStr) + "/package", attrs);
            String ns = this.getAttribute(navigator, "namespace", String.valueOf(errorStr) + "/namespace", attrs);
            globalc.packageNamespaceMap.put(pkgname, ns);
        }
        return globalc;
    }

    public Object newChild(Configuration.WSDLToJavaConfig wsdl2jc, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        String errorStr = "Problem parsing <wsdltojava>";
        if ("mapping".equals(localName)) {
            errorStr = String.valueOf(errorStr) + "/mapping ";
            wsdl2jc.mappingFileNeeded = true;
            wsdl2jc.mappingFileName = this.getAttribute(navigator, "fileName", errorStr, attrs);
        }
        return wsdl2jc;
    }

    public Object newChild(Configuration.OperationConfig op, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("parameter".equals(localName)) {
            return op.createParameterConfig();
        }
        return op;
    }

    public Object addChild(Configuration config, Configuration.WSDLToJavaConfig wsdl2jc, UnmarshallingContext navigator, String namespaceURI, String localName) {
        config.setWSDLToJavaConfig(wsdl2jc);
        return config;
    }

    public Object addChild(Configuration config, Configuration.JavaToWSDLConfig j2wc, UnmarshallingContext navigator, String namespaceURI, String localName) {
        config.setJavaToWSDLConfig(j2wc);
        return config;
    }

    public Object addChild(Configuration.JavaToWSDLConfig j2wc, Configuration.OperationConfig opc, UnmarshallingContext navigator, String namespaceURI, String localName) {
        j2wc.opConfigList.add(opc);
        return j2wc;
    }

    public Object addChild(Configuration.OperationConfig opc, Configuration.ParameterConfig pc, UnmarshallingContext navigator, String namespaceURI, String localName) {
        opc.params.add(pc);
        return opc;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName) {
        return root;
    }

    public void setValue(Configuration.OperationConfig opconfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("name")) {
            opconfig.name = value;
        } else if (localName.equals("oneway")) {
            opconfig.isOneWay = "true".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value);
        }
    }

    public void setValue(Configuration.ParameterConfig paramconfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("java-type")) {
            paramconfig.javaType = value;
        } else if (localName.equals("mime-type")) {
            paramconfig.mimeType = value;
        } else if (localName.equals("xml-name")) {
            paramconfig.xmlName = value;
        }
    }

    private String getOptionalAttribute(UnmarshallingContext navigator, String attribName, String errorStr, Attributes attrs, String defaultValue) {
        String value = null;
        try {
            value = attrs.getValue(attribName);
            if (!value.startsWith("http")) {
                return navigator.resolveQName(value).getLocalPart();
            }
            return value;
        }
        catch (RuntimeException runtimeException) {
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }
    }

    private String getAttribute(UnmarshallingContext navigator, String attribName, String errorStr, Attributes attrs) {
        try {
            String value = attrs.getValue(attribName);
            if (!value.startsWith("http")) {
                return navigator.resolveQName(value).getLocalPart();
            }
            return value;
        }
        catch (RuntimeException runtimeException) {
            throw new WSException(String.valueOf(errorStr) + " attribute=" + attribName);
        }
    }

    private String getNamespace(UnmarshallingContext navigator, String attribName, String errorStr, Attributes attrs) {
        try {
            return attrs.getValue(attribName);
        }
        catch (RuntimeException runtimeException) {
            throw new WSException(String.valueOf(errorStr) + " attribute=" + attribName);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

