/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDLHelper {
    protected WSDLDefinitions wsdl = null;
    protected String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
    protected JavaToXSDIntf javaToXSD = null;
    protected String wsdlStyle = "RPC/Literal";
    protected Class seiClass = null;
    private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
    protected Map<String, Boolean> features = new HashMap<String, Boolean>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ByteArrayHolder;

    public JavaToWSDLHelper(WSDLDefinitions wsdl, String wsdlNS) {
        this.wsdl = wsdl;
        this.wsdlNamespace = wsdlNS;
    }

    public void appendDefinitions(String targetNamespace) {
        this.wsdl.setTargetNamespace(targetNamespace);
        this.wsdl.registerNamespaceURI(targetNamespace, "tns");
        this.wsdl.registerNamespaceURI("http://www.w3.org/2001/XMLSchema", "xsd");
        if (this.wsdlNamespace.equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        }
    }

    public void generateTypesForXSD(ParameterMetaData pmd) throws IOException {
        if (this.javaToXSD == null) {
            this.javaToXSD = new JavaToXSD();
        }
        this.javaToXSD.getSchemaCreator();
        QName xmlType = pmd.getXmlType();
        if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            this.generateType(xmlType, pmd.getJavaType(), this.buildElementNameMap(pmd));
        }
        if (this.wsdlStyle == "Document/Literal") {
            this.generateElement(pmd.getXmlName(), xmlType);
        }
        if (pmd.isSwA()) {
            this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        }
    }

    private Map<String, QName> buildElementNameMap(ParameterMetaData pmd) {
        List<QName> elements = pmd.getWrappedElementNames();
        List<String> variables = pmd.getWrappedVariables();
        if (elements == null || variables == null) {
            return null;
        }
        if (elements.size() != variables.size()) {
            return null;
        }
        HashMap<String, QName> map = new HashMap<String, QName>(elements.size());
        int i = 0;
        for (String variable : variables) {
            map.put(variable, elements.get(i++));
        }
        return map;
    }

    public void generateTypesForXSD(FaultMetaData fmd) throws IOException {
        this.javaToXSD.getSchemaCreator();
        QName xmlType = fmd.getXmlType();
        if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            this.generateType(xmlType, fmd.getJavaType(), null);
        }
    }

    public void generateInterfaces(OperationMetaData op, String intfName) {
        Class<Void> returnType;
        QName xmlName;
        String opname;
        WSDLUtils.getInstance();
        if (op == null) {
            throw new IllegalArgumentException("Illegal Null Argument: op");
        }
        WSDLInterface wsdlInterface = this.wsdl.getInterface(new NCName(intfName));
        if (wsdlInterface == null) {
            wsdlInterface = new WSDLInterface(this.wsdl);
            wsdlInterface.setName(new NCName(intfName));
            this.wsdl.addInterface(wsdlInterface);
        }
        if ((opname = (xmlName = op.getXmlName()).getLocalPart()) == null || opname.length() == 0) {
            throw new WSException("opname is null or blank");
        }
        WSDLInterfaceOperation wsdlInterfaceOperation = new WSDLInterfaceOperation(wsdlInterface);
        wsdlInterfaceOperation.setName(new NCName(opname));
        wsdlInterface.addOperation(wsdlInterfaceOperation);
        if ("Document/Literal".equals(this.wsdlStyle)) {
            wsdlInterfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/iri");
        } else {
            wsdlInterfaceOperation.setStyle("http://www.w3.org/2004/03/wsdl/style/rpc");
        }
        if (op.isOneWayOperation()) {
            wsdlInterfaceOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
        } else {
            wsdlInterfaceOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
        }
        ArrayList<WSDLInterfaceOperationOutput> holderOuts = new ArrayList<WSDLInterfaceOperationOutput>();
        List<ParameterMetaData> pmds = op.getParameters();
        for (ParameterMetaData pmd : pmds) {
            if (pmd.getMode() != ParameterMode.IN) {
                if (op.isOneWayOperation()) {
                    throw new WSException(new StringBuffer(String.valueOf(opname)).append(" is a oneway operation and").append(" defines a holder").toString());
                }
                holderOuts.add(this.getWSDLInterfaceOperationOutput(wsdlInterfaceOperation, pmd));
                if (pmd.getMode() != ParameterMode.INOUT) continue;
                wsdlInterfaceOperation.addInput(this.getWSDLInterfaceOperationInput(wsdlInterfaceOperation, pmd));
                continue;
            }
            wsdlInterfaceOperation.addInput(this.getWSDLInterfaceOperationInput(wsdlInterfaceOperation, pmd));
        }
        ParameterMetaData retpmd = op.getReturnParameter();
        Class<Void> clazz = returnType = retpmd != null ? retpmd.getClass() : Void.TYPE;
        if (returnType != null && Void.TYPE != returnType) {
            wsdlInterfaceOperation.addOutput(this.getWSDLInterfaceOperationOutput(wsdlInterfaceOperation, retpmd));
        }
        for (WSDLInterfaceOperationOutput wo : holderOuts) {
            wsdlInterfaceOperation.addOutput(wo);
        }
        List<FaultMetaData> fmds = op.getFaults();
        for (FaultMetaData fmd : fmds) {
            this.generateWSDLFaults(wsdlInterfaceOperation, fmd.getXmlName());
        }
    }

    public void generateBindings(OperationMetaData op, String bindName) {
        Class<Void> returnType;
        WSDLUtils utils = WSDLUtils.getInstance();
        String intfName = utils.chop(bindName, "Binding");
        WSDLBinding wsdlBinding = this.wsdl.getBinding(new NCName(bindName));
        if (wsdlBinding == null) {
            wsdlBinding = new WSDLBinding(this.wsdl);
            wsdlBinding.setName(new NCName(bindName));
            wsdlBinding.setInterfaceName(new QName(this.wsdl.getTargetNamespace(), intfName));
            this.wsdl.addBinding(wsdlBinding);
        }
        String opname = op.getXmlName().getLocalPart();
        WSDLBindingOperation wsdlBindingOperation = new WSDLBindingOperation(wsdlBinding);
        wsdlBindingOperation.setRef(new QName(this.wsdl.getTargetNamespace(), opname));
        wsdlBinding.addOperation(wsdlBindingOperation);
        List<ParameterMetaData> pmds = op.getInputParameters();
        for (ParameterMetaData pmd : pmds) {
            WSDLBindingOperationInput wsdlBindingOperationInput = new WSDLBindingOperationInput(wsdlBindingOperation);
            wsdlBindingOperationInput.setMessageLabel(new NCName(pmd.getXmlName().getLocalPart()));
            wsdlBindingOperation.addInput(wsdlBindingOperationInput);
        }
        ParameterMetaData retpmd = op.getReturnParameter();
        Class<Void> clazz = returnType = retpmd != null ? retpmd.getClass() : Void.TYPE;
        if (returnType != null && Void.TYPE != returnType) {
            WSDLBindingOperationOutput wsdlBindingOperationOutput = new WSDLBindingOperationOutput(wsdlBindingOperation);
            wsdlBindingOperationOutput.setMessageLabel(new NCName(retpmd.getXmlName().getLocalPart()));
            wsdlBindingOperation.addOutput(wsdlBindingOperationOutput);
        }
        pmds = op.getOutputParameters();
        for (ParameterMetaData pmd : pmds) {
            WSDLBindingOperationOutput wsdlBindingOperationOutput = new WSDLBindingOperationOutput(wsdlBindingOperation);
            wsdlBindingOperationOutput.setMessageLabel(new NCName(pmd.getXmlName().getLocalPart()));
            wsdlBindingOperation.addOutput(wsdlBindingOperationOutput);
        }
        List<FaultMetaData> fmds = op.getFaults();
        for (FaultMetaData fmd : fmds) {
            WSDLBindingFault f = new WSDLBindingFault(wsdlBinding);
            String faultName = fmd.getXmlName().getLocalPart();
            WSDLInterfaceFault intFault = this.wsdl.getInterface(new NCName(intfName)).getFault(new NCName(faultName));
            if (intFault == null) {
                throw new WSException(new StringBuffer("Fault in WSDLInterface for name=").append(faultName).append(" not found").toString());
            }
            QName fqname = new QName(this.wsdl.getTargetNamespace(), faultName);
            f.setRef(fqname);
        }
    }

    public void generateServices(EndpointMetaData endpt, String intfName) {
        if (endpt == null) {
            throw new WSException("Illegal Null Argument: endpt");
        }
        String serviceName = endpt.getServiceMetaData().getName().getLocalPart();
        WSDLService wsdlService = new WSDLService(this.wsdl);
        wsdlService.setName(new NCName(serviceName));
        this.wsdl.addService(wsdlService);
        String portName = endpt.getName().getLocalPart();
        WSDLInterface wsdlInterface = this.wsdl.getInterface(new NCName(intfName));
        if (wsdlInterface == null) {
            throw new WSException(new StringBuffer("WSDL Interface for name = ").append(intfName).append(" is null").toString());
        }
        QName seiQName = wsdlInterface.getQName();
        WSDLBinding wsdlBinding = this.wsdl.getBindings()[0];
        NCName bindingName = wsdlBinding.getName();
        QName bindingQName = new QName(this.wsdl.getTargetNamespace(), bindingName.toString());
        wsdlService.setInterfaceName(seiQName);
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint(wsdlService);
        wsdlEndpoint.setName(new NCName(portName));
        wsdlEndpoint.setBinding(bindingQName);
        wsdlEndpoint.setAddress("REPLACE_WITH_ACTUAL_URL");
        wsdlService.addEndpoint(wsdlEndpoint);
    }

    public TypeMapping getTypeMapping() {
        return this.javaToXSD.getSchemaCreator().getTypeMapping();
    }

    public void setPackageNamespaceMap(Map<String, String> map) {
        this.javaToXSD.setPackageNamespaceMap(map);
    }

    public void setEndpoint(Class cls) {
        this.seiClass = cls;
    }

    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public void setJavaToXSD(JavaToXSDIntf jxsd) {
        this.javaToXSD = jxsd;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public void setWSDLStyle(String wsdlStyle) {
        this.wsdlStyle = wsdlStyle;
    }

    protected void generateType(QName xmlType, Class javaType, Map<String, QName> elementNames) throws IOException {
        JBossXSModel xsModel;
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = JavaToWSDLHelper.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(javaType)) {
            javaType = WSDLUtils.getInstance().getJavaTypeForHolder(javaType);
        }
        if ((xsModel = this.javaToXSD.generateForSingleType(xmlType, javaType, elementNames)) == null) {
            throw new WSException("XSModel is null");
        }
        WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
        wsdlTypes.addSchemaModel(xmlType.getNamespaceURI(), xsModel);
        this.wsdl.registerNamespaceURI(xmlType.getNamespaceURI(), null);
        SchemaCreatorIntf schemaCreator = this.javaToXSD.getSchemaCreator();
        this.mergeJavaWsdlMapping(schemaCreator.getJavaWsdlMapping());
        HashMap map = schemaCreator.getCustomNamespaceMap();
        Set keys = map != null ? map.keySet() : null;
        Iterator iter = keys != null && !keys.isEmpty() ? keys.iterator() : null;
        while (iter != null && iter.hasNext()) {
            String pref = (String)iter.next();
            String ns = (String)map.get(pref);
            if (ns == null) continue;
            this.wsdl.registerNamespaceURI(ns, pref);
        }
    }

    private void mergeJavaWsdlMapping(JavaWsdlMapping source) {
        JavaXmlTypeMapping[] javaXmlTypeMappingArray = source.getJavaXmlTypeMappings();
        int n = 0;
        int n2 = javaXmlTypeMappingArray.length;
        while (n < n2) {
            JavaXmlTypeMapping type = javaXmlTypeMappingArray[n];
            JavaXmlTypeMapping typeCopy = new JavaXmlTypeMapping(this.javaWsdlMapping);
            typeCopy.setQNameScope(type.getQnameScope());
            typeCopy.setAnonymousTypeQName(type.getAnonymousTypeQName());
            typeCopy.setJavaType(type.getJavaType());
            typeCopy.setRootTypeQName(type.getRootTypeQName());
            VariableMapping[] variableMappingArray = type.getVariableMappings();
            int n3 = 0;
            int n4 = variableMappingArray.length;
            while (n3 < n4) {
                VariableMapping variable = variableMappingArray[n3];
                VariableMapping variableCopy = new VariableMapping(typeCopy);
                variableCopy.setDataMember(variable.isDataMember());
                variableCopy.setJavaVariableName(variable.getJavaVariableName());
                variableCopy.setXmlAttributeName(variable.getXmlAttributeName());
                variableCopy.setXmlElementName(variable.getXmlElementName());
                variableCopy.setXmlWildcard(variable.getXmlWildcard());
                typeCopy.addVariableMapping(variableCopy);
                ++n3;
            }
            this.javaWsdlMapping.addJavaXmlTypeMappings(typeCopy);
            ++n;
        }
    }

    protected void generateElement(QName xmlName, QName xmlType) {
        WSDLTypes types = this.wsdl.getWsdlTypes();
        JBossXSModel schemaModel = types.getSchemaModel();
        XSTypeDefinition type = schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
        WSSchemaUtils utils = WSSchemaUtils.getInstance(schemaModel.getNamespaceRegistry(), null);
        JBossXSElementDeclaration element = utils.createGlobalXSElementDeclaration(xmlName.getLocalPart(), type, xmlName.getNamespaceURI());
        schemaModel.addXSElementDeclaration(element);
        this.wsdl.registerNamespaceURI(xmlName.getNamespaceURI(), null);
    }

    protected String getXMLNameForArray(QName el) {
        WSDLUtils utils = WSDLUtils.getInstance();
        String xmlName = "";
        String localpart = el.getLocalPart();
        while (localpart.lastIndexOf("Array") > -1) {
            xmlName = new StringBuffer(String.valueOf(xmlName)).append("arrayOf").toString();
            localpart = utils.chop(localpart, "Array");
        }
        xmlName = new StringBuffer(String.valueOf(xmlName)).append(localpart).toString();
        return xmlName;
    }

    protected QName getXMLSchemaType(Class javaType) {
        String prefix;
        LiteralTypeMapping ty = this.javaToXSD.getSchemaCreator().getTypeMapping();
        QName qn = ty.getXMLType(javaType);
        if (qn != null && (qn.getPrefix() == null || qn.getPrefix().length() == 0) && (prefix = this.wsdl.getPrefix(qn.getNamespaceURI())) != null) {
            qn = new QName(qn.getNamespaceURI(), qn.getLocalPart(), prefix);
        }
        return qn;
    }

    protected Class getJavaType(QName xmlType) {
        LiteralTypeMapping ty = this.javaToXSD.getSchemaCreator().getTypeMapping();
        return ty.getJavaType(xmlType);
    }

    private boolean needsToolsOverride(Class paramType) {
        return (class$javax$xml$rpc$holders$ByteArrayHolder == null ? (class$javax$xml$rpc$holders$ByteArrayHolder = JavaToWSDLHelper.class$("javax.xml.rpc.holders.ByteArrayHolder")) : class$javax$xml$rpc$holders$ByteArrayHolder) == paramType;
    }

    private QName getOverrideQName(Class paramType) {
        if ((class$javax$xml$rpc$holders$ByteArrayHolder == null ? (class$javax$xml$rpc$holders$ByteArrayHolder = JavaToWSDLHelper.class$("javax.xml.rpc.holders.ByteArrayHolder")) : class$javax$xml$rpc$holders$ByteArrayHolder) == paramType) {
            return Constants.TYPE_LITERAL_BASE64BINARY;
        }
        throw new WSException("paramType not recognized");
    }

    private void generateWSDLFaults(WSDLInterfaceOperation op, QName xmlName) {
        WSDLInterface wsdlInterface = op.getWsdlInterface();
        WSDLInterfaceFault fault = wsdlInterface.getFault(new NCName(xmlName.getLocalPart()));
        if (fault == null) {
            fault = new WSDLInterfaceFault(wsdlInterface);
            fault.setName(new NCName(xmlName.getLocalPart()));
            fault.setXmlName(xmlName);
            wsdlInterface.addFault(fault);
        }
        WSDLInterfaceOperationOutfault outFault = new WSDLInterfaceOperationOutfault(op);
        outFault.setRef(xmlName);
        op.addOutfault(outFault);
    }

    private WSDLInterfaceOperationOutput getWSDLInterfaceOperationOutput(WSDLInterfaceOperation intf, ParameterMetaData pmd) {
        QName xmlType = pmd.getXmlType();
        QName xmlName = pmd.getXmlName();
        String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
        WSDLProperty wprop = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", new StringBuffer(String.valueOf(prefix)).append(":").append(xmlType.getLocalPart()).toString());
        WSDLInterfaceOperationOutput wsdlInterfaceOperationOutput = new WSDLInterfaceOperationOutput(intf);
        wsdlInterfaceOperationOutput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/partname", xmlName.getLocalPart()));
        wsdlInterfaceOperationOutput.setElement(xmlName);
        wsdlInterfaceOperationOutput.setMessageLabel(new NCName("OUT"));
        wsdlInterfaceOperationOutput.addProperty(wprop);
        if (pmd.isInHeader()) {
            wsdlInterfaceOperationOutput.addProperty(new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", null));
        }
        return wsdlInterfaceOperationOutput;
    }

    private WSDLInterfaceOperationInput getWSDLInterfaceOperationInput(WSDLInterfaceOperation intf, ParameterMetaData pmd) {
        QName xmlType = pmd.getXmlType();
        QName xmlName = pmd.getXmlName();
        WSDLInterfaceOperationInput wsdlInput = new WSDLInterfaceOperationInput(intf);
        String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
        WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", new StringBuffer(String.valueOf(prefix)).append(":").append(xmlType.getLocalPart()).toString());
        wsdlInput.addProperty(wsdlProperty);
        wsdlInput.setElement(xmlName);
        wsdlInput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/partname", xmlName.getLocalPart()));
        wsdlInput.setMessageLabel(new NCName("IN"));
        if (pmd.isInHeader()) {
            wsdlInput.addProperty(new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", null));
        }
        return wsdlInput;
    }

    private boolean checkAttachmentBasedOperation(OperationMetaData op) {
        boolean isAttach = false;
        List<ParameterMetaData> params = op.getParameters();
        for (ParameterMetaData param : params) {
            if (!param.isSwA()) continue;
            isAttach = true;
            break;
        }
        return isAttach;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

