/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PortMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationPart;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.utils.JavaUtils;
import org.jboss.ws.utils.ToolsUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileGeneratorHelper {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$tools$helpers$MappingFileGeneratorHelper == null ? (class$org$jboss$ws$tools$helpers$MappingFileGeneratorHelper = MappingFileGeneratorHelper.class$("org.jboss.ws.tools.helpers.MappingFileGeneratorHelper")) : class$org$jboss$ws$tools$helpers$MappingFileGeneratorHelper));
    private WSDLDefinitions wsdlDefinitions = null;
    private String serviceName = null;
    private String packageName = null;
    private Class serviceEndpointInterface = null;
    private String typeNamespace = null;
    private LiteralTypeMapping typeMapping = null;
    private String wsdlStyle;
    private WSDLUtils utils = WSDLUtils.getInstance();
    private List<XSTypeDefinition> queueTypes = new ArrayList<XSTypeDefinition>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$org$jboss$ws$tools$helpers$MappingFileGeneratorHelper;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class array$Ljava$lang$Byte;

    public MappingFileGeneratorHelper(WSDLDefinitions wsdl, String sname, String pname, Class seiClass, String tns, LiteralTypeMapping ltm) {
        this.wsdlDefinitions = wsdl;
        this.serviceName = sname;
        this.packageName = pname;
        this.serviceEndpointInterface = seiClass;
        this.typeNamespace = tns;
        this.typeMapping = ltm;
        this.wsdlStyle = this.utils.getWSDLStyle(wsdl);
        this.checkEssentials();
    }

    public PackageMapping constructPackageMapping(JavaWsdlMapping jwm, String packageType, String ns) {
        PackageMapping pk = new PackageMapping(jwm);
        pk.setPackageType(packageType);
        pk.setNamespaceURI(ns);
        return pk;
    }

    public ServiceInterfaceMapping constructServiceInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser) {
        this.serviceName = ser.getName().toString();
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        String prefix = "serviceNS";
        ServiceInterfaceMapping sim = new ServiceInterfaceMapping(jwm);
        sim.setServiceInterface(new StringBuffer(String.valueOf(this.packageName)).append(".").append(this.serviceName).toString());
        sim.setWsdlServiceName(new QName(targetNS, this.serviceName, prefix));
        WSDLEndpoint[] endpoints = ser.getEndpoints();
        int lenendpoints = 0;
        if (endpoints != null) {
            lenendpoints = endpoints.length;
        }
        int j = 0;
        while (j < lenendpoints) {
            WSDLEndpoint endpt = endpoints[j];
            String portname = endpt.getName().toString();
            PortMapping pm = new PortMapping(sim);
            pm.setPortName(portname);
            pm.setJavaPortName(portname);
            sim.addPortMapping(pm);
            ++j;
        }
        return sim;
    }

    public void constructServiceEndpointInterfaceMapping(JavaWsdlMapping jwm, WSDLService ser) {
        this.serviceName = ser.getName().toString();
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new IllegalArgumentException("MappingFileGenerator:Service Name is null");
        }
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        WSDLEndpoint[] endpoints = ser.getEndpoints();
        int lenendpoints = 0;
        if (endpoints != null) {
            lenendpoints = endpoints.length;
        }
        int j = 0;
        while (j < lenendpoints) {
            WSDLEndpoint endpt = endpoints[j];
            QName binding = endpt.getBinding();
            WSDLBinding wsdlbind = this.wsdlDefinitions.getBinding(new NCName(binding.getLocalPart()));
            String bindName = wsdlbind.getName().toString();
            String portTypeName = wsdlbind.getInterfaceName().getLocalPart();
            WSDLInterface wsdlintf = this.wsdlDefinitions.getInterface(new NCName(portTypeName));
            String portName = wsdlintf.getName().toString();
            ServiceEndpointInterfaceMapping seim = new ServiceEndpointInterfaceMapping(jwm);
            seim.setServiceEndpointInterface(new StringBuffer(String.valueOf(this.packageName)).append(".").append(portName).toString());
            seim.setWsdlPortType(new QName(targetNS, portName, "portTypeNS"));
            seim.setWsdlBinding(new QName(targetNS, bindName, "bindingNS"));
            this.constructServiceEndpointMethodMapping(seim, wsdlintf);
            jwm.addServiceEndpointInterfaceMappings(seim);
            ++j;
        }
    }

    public void constructServiceEndpointMethodMapping(ServiceEndpointInterfaceMapping seim, WSDLInterface intf) {
        String portName = intf.getName().toString();
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        WSDLInterfaceOperation[] wioparr = intf.getOperations();
        int len = 0;
        if (wioparr != null) {
            len = wioparr.length;
        }
        int j = 0;
        while (j < len) {
            WSDLInterfaceOperation wiop = wioparr[j];
            String opname = wiop.getName().toString();
            ServiceEndpointMethodMapping semm = new ServiceEndpointMethodMapping(seim);
            semm.setJavaMethodName(ToolsUtils.firstLetterLowerCase(opname));
            semm.setWsdlOperation(opname);
            this.constructMethodParamPartsMapping(semm, wiop);
            seim.addServiceEndpointMethodMapping(semm);
            WSDLInterfaceOperationOutput[] wiopoutarr = wiop.getOutputs();
            WSDLInterfaceOperationPart wiout = null;
            if (wiopoutarr != null && wiopoutarr.length > 0) {
                wiout = wiopoutarr[0];
            }
            if (wiout != null) {
                QName xmlName = wiout.getElement();
                QName xmlType = wiout.getXMLType();
                if (wiop.getInputByPartName(xmlName.getLocalPart()) == null) {
                    String javaType = "";
                    if (this.isDocStyle() && this.serviceEndpointInterface != null) {
                        javaType = new StringBuffer(String.valueOf(this.serviceEndpointInterface.getName())).append("_").append(opname).append("_ResponseStruct").toString();
                    } else {
                        if (this.isDocStyle()) {
                            xmlType = wiout.getXMLType();
                        }
                        javaType = this.getJavaTypeAsStringForReturnType(xmlName, xmlType, (WSDLInterfaceOperationOutput)wiout);
                    }
                    if (this.isDocStyle() || !"void".equals(javaType)) {
                        WSDLProperty wprop;
                        WsdlReturnValueMapping wrvm = new WsdlReturnValueMapping(semm);
                        wrvm.setMethodReturnValue(javaType);
                        if (this.isDocStyle() && this.serviceEndpointInterface == null) {
                            wprop = wiout.getProperty("http://www.jboss.org/jbossws/messagename");
                            wrvm.setWsdlMessage(new QName(targetNS, wprop.getValue(), "wsdlMsgNS"));
                        } else {
                            wrvm.setWsdlMessage(new QName(targetNS, new StringBuffer(String.valueOf(portName)).append("_").append(opname).append("Response").toString(), "wsdlMsgNS"));
                        }
                        if (this.isDocStyle() && this.serviceEndpointInterface == null) {
                            wprop = wiout.getProperty("http://www.jboss.org/jbossws/partname");
                            if (wprop != null) {
                                wrvm.setWsdlMessagePartName(wprop.getValue());
                            }
                        } else {
                            wrvm.setWsdlMessagePartName("result");
                        }
                        semm.setWsdlReturnValueMapping(wrvm);
                    }
                }
            }
            ++j;
        }
    }

    public void constructMethodParamPartsMapping(ServiceEndpointMethodMapping semm, WSDLInterfaceOperation wiop) {
        int lenOuts;
        String portName = wiop.getWsdlInterface().getName().toString();
        String opname = wiop.getName().toString();
        WSDLInterfaceOperationInput[] wiopinarr = wiop.getInputs();
        int lenwiopin = wiopinarr != null ? wiopinarr.length : 0;
        int k = 0;
        while (k < lenwiopin) {
            WSDLInterfaceOperationInput win = wiopinarr[k];
            QName xmlName = win.getElement();
            QName xmlType = win.getXMLType();
            String wsdlMessageName = "";
            wsdlMessageName = this.isDocStyle() && this.serviceEndpointInterface == null ? win.getProperty("http://www.jboss.org/jbossws/messagename").getValue() : new StringBuffer(String.valueOf(portName)).append("_").append(opname).toString();
            String partName = xmlName.getLocalPart();
            if (this.isDocStyle()) {
                partName = "parameters";
                if (this.serviceEndpointInterface == null) {
                    partName = win.getProperty("http://www.jboss.org/jbossws/partname").getValue();
                }
            }
            String paramMode = "";
            paramMode = wiop.getOutputByPartName(xmlName.getLocalPart()) != null ? "INOUT" : "IN";
            MethodParamPartsMapping mpin = this.getMethodParamPartsMapping(semm, xmlName, xmlType, k, wsdlMessageName, paramMode, partName);
            semm.addMethodParamPartsMapping(mpin);
            ++k;
        }
        WSDLInterfaceOperationOutput[] outs = wiop.getOutputs();
        int n = lenOuts = outs != null ? outs.length : 0;
        if (lenOuts > 1) {
            int m = 1;
            while (m < lenOuts) {
                WSDLInterfaceOperationOutput out = outs[m];
                if (!this.isInOutHolder(out)) {
                    QName xmlName = out.getElement();
                    QName xmlType = out.getXMLType();
                    MethodParamPartsMapping mpm = this.getMethodParamPartsMapping(semm, xmlName, xmlType, lenwiopin + m - 1, out.getProperty("http://www.jboss.org/jbossws/messagename").getValue(), "OUT", xmlName.getLocalPart());
                    semm.addMethodParamPartsMapping(mpm);
                }
                ++m;
            }
        }
    }

    public void constructJavaXmlTypeMapping(JavaWsdlMapping jwm) {
        ArrayList<String> outArr = new ArrayList<String>();
        WSDLInterface[] intfArr = this.wsdlDefinitions.getInterfaces();
        int len = intfArr != null ? intfArr.length : 0;
        int i = 0;
        while (i < len) {
            Iterator wi = intfArr[i];
            WSDLInterfaceOperation[] ops = ((WSDLInterface)((Object)wi)).getOperations();
            int lenOps = ops.length;
            int j = 0;
            while (j < lenOps) {
                JavaXmlTypeMapping jxtm = null;
                WSDLInterfaceOperation op = ops[j];
                WSDLInterfaceOperationInput[] inputs = op.getInputs();
                int lenin = inputs.length;
                int k = 0;
                while (k < lenin) {
                    WSDLInterfaceOperationInput input = inputs[k];
                    XSTypeDefinition xt = this.getXSType(input);
                    jxtm = this.getJavaXMLTypeMap(xt, jwm);
                    if (jxtm != null) {
                        this.addJavaXMLTypeMapping(jwm, jxtm);
                    }
                    if (this.isDocStyle()) {
                        JavaXmlTypeMapping[] jarr = this.getJavaXmlTypeMappingDocLit(xt, jwm);
                        int lenJArr = jarr != null ? jarr.length : 0;
                        int jr = 0;
                        while (jr < lenJArr) {
                            this.addJavaXMLTypeMapping(jwm, jarr[jr]);
                            ++jr;
                        }
                    } else {
                        jxtm = this.getJavaXMLTypeMap(xt, jwm);
                        if (jxtm != null) {
                            this.addJavaXMLTypeMapping(jwm, jxtm);
                        }
                    }
                    ++k;
                }
                WSDLInterfaceOperationOutput[] outputs = op.getOutputs();
                int lenout = outputs.length;
                int k2 = 0;
                while (k2 < lenout && this.isDocStyle()) {
                    WSDLInterfaceOperationOutput output = outputs[k2];
                    QName elType = output.getXMLType();
                    if (!"http://www.w3.org/2001/XMLSchema".equals(elType.getNamespaceURI())) {
                        String outName = elType.getLocalPart();
                        outArr.add(outName);
                    }
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        if (this.isDocStyle()) {
            for (String outName : outArr) {
                this.generateJavaXmlTypeMappingForResponseStruct(outName, jwm);
            }
            for (String outName : outArr) {
                this.generateJavaXmlTypeMappingForRequestStruct(outName, jwm);
            }
        }
        int lenQ = this.queueTypes.size();
        int i2 = 0;
        while (i2 < lenQ) {
            XSTypeDefinition xt = this.queueTypes.get(i2);
            JavaXmlTypeMapping jxtm = this.getJavaXMLTypeMap(xt, jwm);
            if (jxtm != null) {
                this.addJavaXMLTypeMapping(jwm, jxtm);
            }
            ++i2;
        }
    }

    private void checkEssentials() {
        if (this.typeMapping == null) {
            throw new WSException("typeMapping is null");
        }
    }

    private XSTypeDefinition getXSType(WSDLInterfaceOperationPart part) {
        WSDLInterfaceOperation op = part.getWsdlOperation();
        String zeroarg1 = null;
        Object zeroarg2 = null;
        WSDLProperty prop1 = op.getProperty("http://www.jboss.org/jbossws/zero-args");
        if (prop1 != null) {
            zeroarg1 = prop1.getValue();
        }
        if (zeroarg1 != null && zeroarg2 != null && !zeroarg1.equals(zeroarg2)) {
            return null;
        }
        if (zeroarg1 != null && "true".equals(zeroarg1)) {
            return null;
        }
        QName xmlType = part.getXMLType();
        WSDLTypes types = this.wsdlDefinitions.getWsdlTypes();
        JBossXSModel xsmodel = types.getSchemaModel();
        return xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
    }

    private JavaXmlTypeMapping getJavaXMLTypeMap(XSTypeDefinition xt, JavaWsdlMapping jwm) {
        JavaXmlTypeMapping jxtm = null;
        if (xt instanceof XSComplexTypeDefinition && !this.isRepresentsArray(xt)) {
            XSParticle xp;
            XSTerm xterm;
            jxtm = new JavaXmlTypeMapping(jwm);
            String javaType = this.getJavaTypeAsString(null, new QName(xt.getNamespace(), xt.getName()));
            jxtm.setJavaType(javaType);
            XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xt;
            jxtm.setRootTypeQName(new QName(xc.getNamespace(), xc.getName(), "typeNS"));
            jxtm.setQNameScope("complexType");
            if (xc.getContentType() != 0 && (xterm = (xp = xc.getParticle()).getTerm()) instanceof XSModelGroup) {
                XSModelGroup xm = (XSModelGroup)xterm;
                List<VariableMapping> lst = this.getVariableMappingMap(xm, jxtm, javaType);
                for (VariableMapping vm : lst) {
                    jxtm.addVariableMapping(vm);
                }
            }
        }
        return jxtm;
    }

    private List<VariableMapping> getVariableMappingMap(XSModelGroup xm, JavaXmlTypeMapping jxtm, String javaType) {
        ArrayList<VariableMapping> list = new ArrayList<VariableMapping>();
        XSObjectList xo = xm.getParticles();
        int len = xo != null ? xo.getLength() : 0;
        int i = 0;
        while (i < len) {
            XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
            if (xsterm instanceof XSModelGroup) {
                list.addAll(this.getVariableMappingMap((XSModelGroup)xsterm, jxtm, javaType));
            } else if (xsterm instanceof XSElementDeclaration) {
                XSElementDeclaration xe = (XSElementDeclaration)xsterm;
                VariableMapping vm = new VariableMapping(jxtm);
                String name = xe.getName();
                vm.setJavaVariableName(name);
                Class javaClass = null;
                try {
                    javaClass = JavaUtils.loadJavaType(javaType);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)e);
                }
                if (javaClass != null) {
                    vm.setDataMember(this.isPublicField(javaClass, name));
                } else {
                    log.debug((Object)new StringBuffer("Class for ").append(javaType).append(" is not loaded. So datamember check not done").toString());
                }
                vm.setXmlElementName(name);
                XSTypeDefinition xst = xe.getTypeDefinition();
                if (!"http://www.w3.org/2001/XMLSchema".equals(xst.getNamespace()) && !this.isRepresentsArray(xst)) {
                    this.queueTypes.add(xst);
                }
                list.add(vm);
            }
            ++i;
        }
        return list;
    }

    private JavaXmlTypeMapping[] getJavaXmlTypeMappingDocLit(XSTypeDefinition xt, JavaWsdlMapping jwm) {
        ArrayList<JavaXmlTypeMapping> jlist = new ArrayList<JavaXmlTypeMapping>();
        if (!(xt instanceof XSComplexTypeDefinition)) {
            return null;
        }
        XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xt;
        XSParticle xp = xc.getParticle();
        XSTerm xterm = xp.getTerm();
        if (xterm instanceof XSModelGroup) {
            jlist.addAll(this.getJavaXMLTypeMap((XSModelGroup)xterm, jwm));
        }
        JavaXmlTypeMapping[] jarr = new JavaXmlTypeMapping[jlist.size()];
        jlist.toArray(jarr);
        return jarr;
    }

    private List<JavaXmlTypeMapping> getJavaXMLTypeMap(XSModelGroup xm, JavaWsdlMapping jwm) {
        ArrayList<JavaXmlTypeMapping> list = new ArrayList<JavaXmlTypeMapping>();
        XSObjectList xo = xm.getParticles();
        int len = xo != null ? xo.getLength() : 0;
        int i = 0;
        while (i < len) {
            XSElementDeclaration xe;
            JavaXmlTypeMapping jxtm;
            XSTerm xsterm = ((XSParticle)xo.item(i)).getTerm();
            if (xsterm instanceof XSModelGroup) {
                list.addAll(this.getJavaXMLTypeMap((XSModelGroup)xsterm, jwm));
            } else if (xsterm instanceof XSElementDeclaration && (jxtm = this.getJavaXMLTypeMap((xe = (XSElementDeclaration)xsterm).getTypeDefinition(), jwm)) != null) {
                list.add(jxtm);
            }
            ++i;
        }
        return list;
    }

    private void generateJavaXmlTypeMappingForRequestStruct(String request, JavaWsdlMapping jwm) {
        if (this.serviceEndpointInterface == null) {
            throw new WSException("serviceEndpointInterface is null");
        }
        JavaXmlTypeMapping jxtm = new JavaXmlTypeMapping(jwm);
        String op = this.utils.chop(request, "Response");
        String javatype = new StringBuffer(String.valueOf(this.serviceEndpointInterface.getName())).append("_").append(op).append("_RequestStruct").toString();
        jxtm.setJavaType(javatype);
        jxtm.setQNameScope("complexType");
        jxtm.setRootTypeQName(new QName(this.typeNamespace, op, "typeNS"));
        JBossXSModel xsModel = this.wsdlDefinitions.getWsdlTypes().getSchemaModel();
        XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xsModel.getTypeDefinition(op, this.typeNamespace);
        jxtm.setRootTypeQName(new QName(xc.getNamespace(), xc.getName(), "typeNS"));
        jxtm.setQNameScope("complexType");
        XSParticle xp = xc.getParticle();
        XSTerm xterm = xp.getTerm();
        if (xterm instanceof XSModelGroup) {
            XSModelGroup xm = (XSModelGroup)xterm;
            XSObjectList xo = xm.getParticles();
            int len = xo != null ? xo.getLength() : 0;
            int i = 0;
            while (i < len) {
                XSElementDeclaration xe = (XSElementDeclaration)((XSParticle)xo.item(i)).getTerm();
                VariableMapping vm = new VariableMapping(jxtm);
                String name = xe.getName();
                vm.setJavaVariableName(name);
                vm.setXmlElementName(name);
                jxtm.addVariableMapping(vm);
                ++i;
            }
        }
        this.addJavaXMLTypeMapping(jwm, jxtm);
    }

    private void generateJavaXmlTypeMappingForResponseStruct(String response, JavaWsdlMapping jwm) {
        if (this.serviceEndpointInterface == null) {
            throw new WSException("serviceEndpointInterface is null");
        }
        JavaXmlTypeMapping jxtm = new JavaXmlTypeMapping(jwm);
        String op = this.utils.chop(response, "Response");
        String javatype = new StringBuffer(String.valueOf(this.serviceEndpointInterface.getName())).append("_").append(op).append("_ResponseStruct").toString();
        jxtm.setJavaType(javatype);
        jxtm.setQNameScope("complexType");
        jxtm.setRootTypeQName(new QName(this.typeNamespace, response, "typeNS"));
        VariableMapping vm = new VariableMapping(jxtm);
        vm.setJavaVariableName("result");
        vm.setXmlElementName("result");
        jxtm.addVariableMapping(vm);
        this.addJavaXMLTypeMapping(jwm, jxtm);
    }

    private Method[] getMethodsGivenOperationName(Class clazz, String opname) {
        ArrayList<Method> alist = new ArrayList<Method>();
        Method[] methodz = clazz.getDeclaredMethods();
        int len = methodz.length;
        int i = 0;
        while (i < len) {
            Method m = methodz[i];
            if (opname.equals(m.getName())) {
                alist.add(m);
            }
            ++i;
        }
        Method[] marr = new Method[alist.size()];
        alist.toArray(marr);
        return marr;
    }

    private String getJavaTypeAsString(QName xmlName, QName xmlType) {
        String jtype = null;
        Class javaType = this.typeMapping.getJavaType(xmlType, true);
        if (xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && "anyType".equals(xmlType.getLocalPart()) && javaType == (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = MappingFileGeneratorHelper.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            Class clazz = javaType = class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = MappingFileGeneratorHelper.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement;
        }
        if ((javaType = this.makeCustomDecisions(javaType, xmlName, xmlType)) == null) {
            log.debug((Object)new StringBuffer("Typemapping lookup failed for ").append(xmlName).toString());
            log.debug((Object)"Falling back to identifier generation");
            jtype = ToolsUtils.getJavaIdentifier(xmlType.getLocalPart());
        } else {
            jtype = javaType.isArray() ? ToolsUtils.getFormattedStringForArray(javaType) : javaType.getName();
        }
        return jtype;
    }

    private String getJavaTypeAsStringForReturnType(QName xmlName, QName xmlType, WSDLInterfaceOperationOutput wiout) {
        String opname;
        Method[] marr;
        if (this.serviceEndpointInterface != null && (marr = this.getMethodsGivenOperationName(this.serviceEndpointInterface, opname = wiout.getWsdlOperation().getName().toString())) != null && marr.length == 1) {
            Class<?> retType = marr[0].getReturnType();
            return retType.isArray() ? ToolsUtils.getFormattedStringForArray(retType) : retType.getName();
        }
        return this.getJavaTypeAsString(xmlName, xmlType);
    }

    private boolean isDocStyle() {
        return "Document/Literal".equals(this.wsdlStyle);
    }

    private boolean isPublicField(Class javaType, String fieldname) {
        Field[] fldarr = this.utils.getPublicFields(javaType);
        int len = fldarr != null ? fldarr.length : 0;
        int i = 0;
        while (i < len) {
            Field fld = fldarr[i];
            if (fieldname.equals(fld.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRepresentsArray(XSTypeDefinition xst) {
        boolean bool = false;
        if (xst instanceof XSComplexTypeDefinition) {
            XSModelGroup xm;
            XSObjectList xo;
            XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xst;
            if (xc.getContentType() == 0) {
                return false;
            }
            XSParticle xsp = xc.getParticle();
            XSTerm xsterm = xsp.getTerm();
            if (xsterm instanceof XSModelGroup && (xo = (xm = (XSModelGroup)xsterm).getParticles()).getLength() == 1) {
                XSParticle xp = (XSParticle)xo.item(0);
                bool = xp.getMaxOccursUnbounded() || xp.getMaxOccurs() > 1;
            }
        }
        return bool;
    }

    private Class makeCustomDecisions(Class javaType, QName xmlName, QName xmlType) {
        if (javaType != null && xmlType != null) {
            if (javaType.isPrimitive() && xmlName != null && Character.isUpperCase(xmlName.getLocalPart().charAt(0))) {
                javaType = this.typeMapping.getJavaType(xmlType);
            }
            if ((array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = MappingFileGeneratorHelper.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte) == javaType && "http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI()) && "base64Binary".equals(xmlType.getLocalPart()) && xmlName.getLocalPart().indexOf("arrayOfbyte") > -1) {
                javaType = array$B == null ? (array$B = MappingFileGeneratorHelper.class$("[B")) : array$B;
            }
        }
        return javaType;
    }

    private boolean isInOutHolder(WSDLInterfaceOperationOutput wout) {
        QName el;
        WSDLInterfaceOperation op = wout.getWsdlOperation();
        WSDLInterfaceOperationInput inp = op.getInput(el = wout.getElement());
        return inp != null;
    }

    private MethodParamPartsMapping getMethodParamPartsMapping(ServiceEndpointMethodMapping semm, QName xmlName, QName xmlType, int paramPosition, String wsdlMessageName, String paramMode, String wsdlMessagePartName) {
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        MethodParamPartsMapping mppm = new MethodParamPartsMapping(semm);
        mppm.setParamPosition(paramPosition);
        String javaType = "";
        javaType = this.isDocStyle() && this.serviceEndpointInterface != null ? new StringBuffer(String.valueOf(this.serviceEndpointInterface.getName())).append("_").append(xmlName.getLocalPart()).append("_RequestStruct").toString() : this.getJavaTypeAsString(xmlName, xmlType);
        mppm.setParamType(javaType);
        WsdlMessageMapping wmm = new WsdlMessageMapping(mppm);
        wmm.setParameterMode(paramMode);
        String wsdlNS = "wsdlMsgNS";
        wmm.setWsdlMessage(new QName(targetNS, wsdlMessageName, wsdlNS));
        wmm.setWsdlMessagePartName(wsdlMessagePartName);
        mppm.setWsdlMessageMapping(wmm);
        return mppm;
    }

    private void addJavaXMLTypeMapping(JavaWsdlMapping jwm, JavaXmlTypeMapping jxtm) {
        JavaXmlTypeMapping[] jxtmarr = jwm.getJavaXmlTypeMappings();
        int len = jxtmarr != null ? jxtmarr.length : 0;
        int i = 0;
        while (i < len) {
            JavaXmlTypeMapping j = jxtmarr[i];
            if (jxtm.getJavaType().equals(j.getJavaType()) && jxtm.getQnameScope().equals(j.getQnameScope())) {
                return;
            }
            ++i;
        }
        jwm.addJavaXmlTypeMappings(jxtm);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

