/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.tools.WSDLToJava;
import org.jboss.ws.tools.WSDotXMLCreator;
import org.jboss.ws.tools.client.ServiceCreator;
import org.jboss.ws.tools.mapping.MappingFileGenerator;
import org.jboss.ws.utils.IOUtils;
import org.jboss.xb.binding.Util;
import org.w3c.dom.Node;

public class ToolsHelper {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$tools$helpers$ToolsHelper == null ? (class$org$jboss$ws$tools$helpers$ToolsHelper = ToolsHelper.class$("org.jboss.ws.tools.helpers.ToolsHelper")) : class$org$jboss$ws$tools$helpers$ToolsHelper));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$tools$helpers$ToolsHelper;

    public void handleJavaToWSDLGeneration(Configuration config, String outDir) throws IOException {
        Class endpointClass;
        Configuration.JavaToWSDLConfig j2wc = config.getJavaToWSDLConfig(false);
        JavaToWSDL jwsdl = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
        jwsdl.setServiceName(j2wc.serviceName);
        jwsdl.setTargetNamespace(j2wc.targetNamespace);
        jwsdl.setTypeNamespace(j2wc.typeNamespace);
        jwsdl.addFeature("http://www.jboss.org/wstools/restrict_types_to_TargetNamespace", j2wc.restrictSchemaToTargetNS);
        if (j2wc.wsdlStyle.equals("document")) {
            jwsdl.setWsdlStyle("Document/Literal");
        }
        if ((endpointClass = this.loadClass(j2wc.endpointName)) == null) {
            throw new WSException("Endpoint " + j2wc.endpointName + " cannot be loaded");
        }
        Configuration.GlobalConfig gcfg = config.getGlobalConfig(false);
        if (gcfg != null && gcfg.packageNamespaceMap != null) {
            jwsdl.setPackageNamespaceMap(gcfg.packageNamespaceMap);
        }
        WSDLDefinitions wsdl = jwsdl.generate(endpointClass);
        this.createDir(String.valueOf(outDir) + "/wsdl");
        String wsdlPath = String.valueOf(outDir) + "/wsdl/" + j2wc.serviceName + ".wsdl";
        Writer fw = IOUtils.getCharsetFileWriter(new File(wsdlPath), "UTF-8");
        wsdl.write(fw, "UTF-8");
        fw.close();
        if (j2wc.mappingFileNeeded) {
            MappingFileGenerator mgf = new MappingFileGenerator(wsdl, jwsdl.getTypeMapping());
            mgf.setPackageName(endpointClass.getPackage().getName());
            mgf.setServiceEndpointInterface(endpointClass);
            mgf.setServiceName(j2wc.serviceName);
            mgf.setTypeNamespace(j2wc.typeNamespace);
            JavaWsdlMapping jwm = mgf.generate();
            fw = new FileWriter(String.valueOf(outDir) + "/" + j2wc.mappingFileName);
            fw.write(DOMWriter.printNode((Node)DOMUtils.parse((String)jwm.serialize()), (boolean)true));
            fw.close();
            if (j2wc.wsdlStyle.equals("document")) {
                String seiName = endpointClass.getName();
                mgf.generateJavaSourceFileForRequestResponseStruct(new File(outDir), jwm.getServiceEndpointInterfaceMapping(seiName), wsdl.getWsdlTypes().getSchemaModel(), j2wc.typeNamespace);
            }
        }
        if (j2wc.wsxmlFileNeeded) {
            WSDotXMLCreator wscr = new WSDotXMLCreator();
            wscr.setTargetNamespace(j2wc.targetNamespace);
            wscr.setSeiName(j2wc.endpointName);
            wscr.setServiceName(j2wc.serviceName);
            WSDLService wsdlService = wsdl.getService(new NCName(j2wc.serviceName));
            String portName = wsdlService.getEndpoints()[0].getName().toString();
            wscr.setPortName(portName);
            if (j2wc.servletLink != null) {
                wscr.setMappingFile("WEB-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("WEB-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setServletLink(j2wc.servletLink);
            } else {
                wscr.setMappingFile("META-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("META-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setEjbLink(j2wc.ejbLink);
            }
            wscr.generateWSXMLDescriptor(new File(String.valueOf(outDir) + "/webservices.xml"));
        }
    }

    public void handleWSDLToJavaGeneration(Configuration config, String outDir) {
        Configuration.WSDLToJavaConfig w2jc = config.getWSDLToJavaConfig(false);
        Configuration.GlobalConfig glc = config.getGlobalConfig(false);
        WSDLToJava wsdlToJava = new WSDLToJava();
        wsdlToJava.setTypeMapping(new LiteralTypeMapping());
        WSDLDefinitions wsdl = null;
        try {
            URL wsdlURL;
            try {
                wsdlURL = new URL(w2jc.wsdlLocation);
            }
            catch (MalformedURLException malformedURLException) {
                wsdlURL = new File(w2jc.wsdlLocation).toURL();
            }
            wsdl = wsdlToJava.convertWSDL2Java(wsdlURL);
            if (glc != null) {
                wsdlToJava.setPackageNamespaceMap(glc.packageNamespaceMap);
            }
            wsdlToJava.generateSEI(wsdl, new File(outDir));
            this.generateServiceFile(this.getPackageName(wsdl, glc), wsdl, outDir);
            if (w2jc.mappingFileNeeded) {
                MappingFileGenerator mgf = new MappingFileGenerator(wsdl, new LiteralTypeMapping());
                mgf.setPackageName(Util.xmlNamespaceToJavaPackage((String)wsdl.getTargetNamespace()));
                mgf.setServiceName(wsdl.getServices()[0].getName().toString());
                JavaWsdlMapping jwm = mgf.generate();
                FileWriter fw = new FileWriter(String.valueOf(outDir) + "/" + w2jc.mappingFileName);
                fw.write(jwm.serialize());
                fw.close();
            }
        }
        catch (MalformedURLException e) {
            throw new WSException(e);
        }
        catch (WSDLException e) {
            throw new WSException(e);
        }
        catch (IOException e) {
            throw new WSException(e);
        }
    }

    private Class loadClass(String cls) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(cls);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Cannot load endpoint:" + e.getLocalizedMessage()));
        }
        return clazz;
    }

    private void generateServiceFile(String packageName, WSDLDefinitions wsdl, String location) throws IOException {
        ServiceCreator sc = new ServiceCreator();
        sc.setPackageName(packageName);
        sc.setDirLocation(new File(location));
        sc.setWsdl(wsdl);
        sc.createServiceDescriptor();
    }

    private String getPackageName(WSDLDefinitions wsdl, Configuration.GlobalConfig glc) {
        String targetNamespace = wsdl.getTargetNamespace();
        if (glc != null && glc.packageNamespaceMap != null) {
            Map<String, String> map = glc.packageNamespaceMap;
            Iterator<String> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String pkg = iter.next();
                String ns = map.get(pkg);
                if (!ns.equals(targetNamespace)) continue;
                return pkg;
            }
        }
        return Util.xmlNamespaceToJavaPackage((String)wsdl.getTargetNamespace());
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

