/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.ToolsUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveMetaDataBuilder {
    private Map<String, Configuration.OperationConfig> opMap = null;
    private Class seiClass = null;
    private ToolsEndpointMetaData tmd = null;
    private String targetNamespace = null;
    private String wsdlStyle = "RPC/Literal";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public ReflectiveMetaDataBuilder(ToolsEndpointMetaData tmd, String wsdlStyle) {
        if (tmd == null) {
            throw new IllegalArgumentException("Illegal Null Argument: tmd");
        }
        if (wsdlStyle == null) {
            throw new IllegalArgumentException("Illegal Null Argument: wsdlStyle");
        }
        this.seiClass = tmd.getServiceEndpointInterface();
        this.checkServiceEndpointInterface();
        this.targetNamespace = tmd.getName().getNamespaceURI();
        this.tmd = tmd;
        this.wsdlStyle = wsdlStyle;
    }

    public void setOperationConfig(List<Configuration.OperationConfig> opCfgList) {
        if (opCfgList == null) {
            throw new IllegalArgumentException("Illegal null argument: opCfgList");
        }
        this.prepareOperationMap(opCfgList);
    }

    public ToolsEndpointMetaData generate() {
        if (this.wsdlStyle.equals("Document/Literal")) {
            this.tmd.setStyle(Style.DOCUMENT);
            this.tmd.setParameterStyle(ParameterStyle.WRAPPED);
        } else {
            this.tmd.setStyle(Style.RPC);
        }
        this.generateOperationMetaData(this.seiClass.getDeclaredMethods());
        return this.tmd;
    }

    private void checkServiceEndpointInterface() {
        if (this.seiClass == null) {
            throw new IllegalArgumentException("Illegal Null Argument: seiClass");
        }
        if (!this.seiClass.isInterface()) {
            throw new IllegalArgumentException("Illegal seiClass : not an interface");
        }
    }

    private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om) {
        String exname = WSDLUtils.getInstance().getJustClassName(exType);
        QName xmlName = new QName(this.tmd.typeNamespace, exname);
        FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
        return fm;
    }

    private void generateOperationMetaData(Method[] marr) {
        if (marr == null) {
            throw new WSException("Number of methods in the seiClass is zero");
        }
        Method[] methodArray = marr;
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Class<?>[] exarr;
            ParameterMetaData retMetaData;
            Configuration.OperationConfig opc;
            Method m = methodArray[n];
            String methodname = m.getName();
            OperationMetaData om = this.getOperationMetaData(m);
            Configuration.OperationConfig operationConfig = opc = this.opMap != null ? this.opMap.get(methodname) : null;
            if (opc != null) {
                om.setOneWayOperation(opc.isOneWay);
            }
            Class<?>[] paramTypes = m.getParameterTypes();
            int len = 0;
            if (paramTypes != null) {
                len = Array.getLength(paramTypes);
            }
            ParameterMetaData wrappedParameter = null;
            ArrayList<String> wrappedVariables = null;
            ArrayList<String> wrappedTypes = null;
            ArrayList<QName> wrappedNames = null;
            if (om.isDocumentWrapped()) {
                QName xmlName;
                QName xmlType = xmlName = new QName(this.tmd.typeNamespace, m.getName());
                wrappedParameter = new ParameterMetaData(om, xmlName, xmlType, null);
                wrappedVariables = new ArrayList<String>(len);
                wrappedTypes = new ArrayList<String>(len);
                wrappedNames = new ArrayList<QName>(len);
                wrappedParameter.setGeneratedWrapper(true);
                wrappedParameter.setWrappedVariables(wrappedVariables);
                wrappedParameter.setWrappedTypes(wrappedTypes);
                wrappedParameter.setWrappedElementNames(wrappedNames);
                om.addParameter(wrappedParameter);
                if (!om.isOneWayOperation()) {
                    xmlType = xmlName = new QName(this.tmd.typeNamespace, new StringBuffer(String.valueOf(m.getName())).append("Response").toString());
                    retMetaData = new ParameterMetaData(om, xmlName, xmlType, null);
                    retMetaData.setGeneratedWrapper(true);
                    retMetaData.setWrappedVariables(new ArrayList<String>(0));
                    retMetaData.setWrappedTypes(new ArrayList<String>(0));
                    om.setReturnParameter(retMetaData);
                }
            }
            boolean hasParamConfig = opc != null && !opc.isOneWay ? opc.params != null : false;
            int i = 0;
            while (i < len) {
                Class<?> paramType;
                if ((class$java$rmi$Remote == null ? ReflectiveMetaDataBuilder.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(paramType = paramTypes[i])) {
                    throw new WSException(new StringBuffer("Param Type ").append(paramType.getName()).append(" should not extend java.rmi.Remote").toString());
                }
                if (om.isDocumentWrapped()) {
                    wrappedTypes.add(paramType.getName());
                    QName xmlName = this.getXmlName(paramType, i);
                    wrappedNames.add(xmlName);
                    wrappedVariables.add(this.convertToProperty(xmlName.getLocalPart()));
                } else if (hasParamConfig) {
                    om.addParameter(this.getParameterMetaData(paramType, om, opc.params.get(i), i));
                } else {
                    om.addParameter(this.getParameterMetaData(paramType, om, i));
                }
                ++i;
            }
            Class<?> returnType = m.getReturnType();
            if (Void.TYPE != returnType) {
                if (om.isDocumentWrapped()) {
                    retMetaData = om.getReturnParameter();
                    retMetaData.getWrappedVariables().add("result");
                    retMetaData.getWrappedTypes().add(returnType.getName());
                } else {
                    om.setReturnParameter(this.getParameterMetaDataForReturnType(returnType, om, 1));
                }
            }
            if (om.isDocumentWrapped()) {
                ParameterWrapping.generateWrapper(wrappedParameter, false);
                if (!om.isOneWayOperation()) {
                    ParameterWrapping.generateWrapper(om.getReturnParameter(), false);
                }
            }
            if ((exarr = m.getExceptionTypes()) != null) {
                int lenEx = Array.getLength(exarr);
                int i2 = 0;
                boolean remExFound = false;
                while (i2 < lenEx && !remExFound) {
                    if ((class$java$rmi$RemoteException == null ? ReflectiveMetaDataBuilder.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exarr[i2])) {
                        remExFound = true;
                    }
                    ++i2;
                }
                if (!remExFound) {
                    throw new WSException(new StringBuffer(String.valueOf(m.getName())).append(" does not define ").append("an exception that is either RemoteException or derivative of it").toString());
                }
                i2 = 0;
                while (i2 < lenEx) {
                    Class<?> exClass;
                    if (!(class$java$rmi$RemoteException == null ? ReflectiveMetaDataBuilder.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exClass = exarr[i2])) {
                        om.addFault(this.getFaultMetaData(exClass, om));
                    }
                    ++i2;
                }
            }
            this.tmd.addOperation(om);
            ++n;
        }
    }

    private OperationMetaData getOperationMetaData(Method m) {
        String methodname = m.getName();
        OperationMetaData om = new OperationMetaData(this.tmd, new QName(this.targetNamespace, methodname), methodname);
        om.setSOAPAction("");
        return om;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, Configuration.ParameterConfig pc, int index) {
        String xmlNameStr;
        String defaultName = this.getDefaultName(type);
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        String string = xmlNameStr = pc.xmlName != null ? pc.xmlName : new StringBuffer(String.valueOf(defaultName)).append("_").append(index + 1).toString();
        if (pc.mimeType != null) {
            String mimeType = pc.mimeType;
            xmlType = ToolsUtils.getXMLTypeForAttachmentType(mimeType);
        }
        ParameterMetaData pm = new ParameterMetaData(om, new QName(this.tmd.typeNamespace, xmlNameStr), xmlType, defaultName);
        if (pc.mimeType != null) {
            pm.setSwA(true);
            pm.setMimeTypes(pc.mimeType);
        }
        return pm;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, int index) {
        boolean holder = false;
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = ReflectiveMetaDataBuilder.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type)) {
            type = HolderUtils.getValueType(type);
            holder = true;
        }
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        QName xmlName = this.getXmlName(type, index);
        ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
        if (holder) {
            pm.setMode(ParameterMode.INOUT);
        }
        return pm;
    }

    private QName getXmlName(Class type, int index) {
        String defaultName = this.getDefaultName(type);
        String xmlNameStr = new StringBuffer(String.valueOf(defaultName)).append("_").append(index + 1).toString();
        QName xmlName = new QName(this.tmd.typeNamespace, xmlNameStr);
        return xmlName;
    }

    private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, int index) {
        String typeNamespace = this.tmd.typeNamespace;
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ReflectiveMetaDataBuilder.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(type)) {
            throw new WSException(new StringBuffer(String.valueOf(om.getJavaName())).append(" has return type which ").append("should not extend java.rmi.Remote").toString());
        }
        String tns = this.targetNamespace;
        String name = "result";
        if (typeNamespace != null && !tns.equals(typeNamespace)) {
            tns = typeNamespace;
        }
        QName xmlType = ToolsUtils.getXMLType(type, tns);
        ParameterMetaData pm = new ParameterMetaData(om, new QName(tns, name), xmlType, type.getName());
        return pm;
    }

    private void prepareOperationMap(List<Configuration.OperationConfig> opCfgList) {
        this.opMap = new HashMap<String, Configuration.OperationConfig>();
        for (Configuration.OperationConfig oc : opCfgList) {
            String name = oc.name;
            if (this.opMap.get(name) != null) {
                throw new WSException("Overloaded operations not supported");
            }
            this.opMap.put(name, oc);
        }
    }

    private String getDefaultName(Class javaClass) {
        String name = "";
        WSDLUtils utils = WSDLUtils.getInstance();
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = ReflectiveMetaDataBuilder.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        if (javaClass.isArray()) {
            int len = utils.getArrayDimension(javaClass);
            int i = 0;
            while (i < len) {
                javaClass = javaClass.getComponentType();
                ++i;
            }
            name = utils.getMessagePartForArray(utils.getJustClassName(javaClass));
        } else {
            name = utils.getJustClassName(javaClass);
        }
        return name;
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuffer builder = new StringBuffer(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

