/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.schema;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModelGroup;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSParticle;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
import org.jboss.xb.binding.NamespaceRegistry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTypeCreator
implements SchemaCreatorIntf {
    protected Logger log = Logger.getLogger((Class)(class$org$jboss$ws$tools$schema$SchemaTypeCreator == null ? (class$org$jboss$ws$tools$schema$SchemaTypeCreator = SchemaTypeCreator.class$("org.jboss.ws.tools.schema.SchemaTypeCreator")) : class$org$jboss$ws$tools$schema$SchemaTypeCreator));
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected SchemaUtils schemautils = SchemaUtils.getInstance();
    protected WSSchemaUtils sutils = null;
    protected LiteralTypeMapping typeMapping = new LiteralTypeMapping();
    private NamespaceRegistry namespaces = null;
    private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
    protected String xsNS = "http://www.w3.org/2001/XMLSchema";
    private int maxPrefix = 1;
    protected JBossXSModel xsModel = null;
    protected Map<String, String> packageNamespaceMap = new HashMap<String, String>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$ejb$SessionBean;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$org$jboss$ws$tools$schema$SchemaTypeCreator;

    public SchemaTypeCreator() {
        this.xsModel = new JBossXSModel();
        this.namespaces = this.xsModel.getNamespaceRegistry();
        this.sutils = WSSchemaUtils.getInstance(this.namespaces, null);
    }

    @Override
    public void addPackageNamespaceMapping(String pkgname, String ns) {
        if (pkgname == null) {
            throw new IllegalArgumentException("Illegal Null Argument:pkgname");
        }
        if (ns == null) {
            throw new IllegalArgumentException("Illegal Null Argument:ns");
        }
        this.packageNamespaceMap.put(pkgname, ns);
    }

    @Override
    public JBossXSTypeDefinition generateType(QName xmlType, Class javaType) {
        return this.generateType(xmlType, javaType, null);
    }

    @Override
    public JBossXSTypeDefinition generateType(QName xmlType, Class javaType, Map<String, QName> elementNames) {
        return this.getType(xmlType, javaType, elementNames);
    }

    @Override
    public QName getXMLSchemaType(Class javaType) {
        QName xmlt = this.schemautils.getToolsOverrideInTypeMapping(javaType);
        if (xmlt == null) {
            xmlt = this.typeMapping.getXMLType(javaType, false);
        }
        return xmlt;
    }

    @Override
    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    @Override
    public JBossXSModel getXSModel() {
        return this.xsModel;
    }

    @Override
    public HashMap getCustomNamespaceMap() {
        HashMap<String, String> map = null;
        if (this.namespaces != null) {
            Iterator iter = this.namespaces.getRegisteredPrefixes();
            while (iter != null && iter.hasNext()) {
                String prefix = (String)iter.next();
                if (!prefix.startsWith("ns")) continue;
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                map.put(prefix, this.namespaces.getNamespaceURI(prefix));
            }
        }
        return map;
    }

    @Override
    public Map<String, String> getPackageNamespaceMap() {
        return this.packageNamespaceMap;
    }

    @Override
    public LiteralTypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public Class getJavaType(QName xmlType) {
        Class retType = this.typeMapping.getJavaType(xmlType);
        if (retType == null) {
            throw new IllegalArgumentException(new StringBuffer("Unsupported type: ").append(xmlType).toString());
        }
        return retType;
    }

    @Override
    public void setXSModel(JBossXSModel xsm) {
        this.xsModel = xsm;
    }

    @Override
    public String allocatePrefix(String nsURI) {
        String prefix = this.namespaces.getPrefix(nsURI);
        return prefix == null ? this.namespaces.registerURI(nsURI, null) : prefix;
    }

    @Override
    public void setPackageNamespaceMap(Map<String, String> packageNamespaceMap) {
        this.packageNamespaceMap = packageNamespaceMap;
    }

    private JBossXSTypeDefinition checkTypeExistsInXSModel(QName xmlt) {
        JBossXSTypeDefinition ct = null;
        if (xmlt != null && this.xsModel != null) {
            ct = this.getXSTypeDefinitionIfPresent(xmlt);
        }
        return ct;
    }

    private JBossXSTypeDefinition getType(QName xmlType, Class javaType, Map<String, QName> elementNames) {
        JBossXSTypeDefinition ct = null;
        boolean registered = false;
        registered = xmlType == null ? (xmlType = this.getXMLSchemaType(javaType)) != null : this.typeMapping.isRegistered(javaType, xmlType);
        if (registered) {
            ct = this.checkTypeExistsInXSModel(xmlType);
        }
        if (ct == null && xmlType != null && "http://www.w3.org/2001/XMLSchema".equals(xmlType.getNamespaceURI()) && !javaType.isArray()) {
            ct = this.schemautils.getSchemaBasicType(xmlType.getLocalPart());
        }
        if (ct == null && (class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaTypeCreator.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(javaType)) {
            ct = this.getComplexTypeForJavaException(xmlType, javaType);
        }
        if (ct == null) {
            ct = this.generateNewType(xmlType, javaType, elementNames);
        }
        return ct;
    }

    private JBossXSTypeDefinition getXSTypeDefinitionIfPresent(QName qname) {
        return (JBossXSTypeDefinition)this.xsModel.getTypeDefinition(qname.getLocalPart(), qname.getNamespaceURI());
    }

    private JBossXSTypeDefinition generateNewType(QName xmlType, Class javaType, Map<String, QName> elementNames) {
        String namespace;
        String name;
        Class superclass = javaType.getSuperclass();
        JBossXSTypeDefinition baseType = null;
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>();
        if (superclass != null && !this.utils.checkIgnoreClass(superclass) && (baseType = this.generateType(null, superclass)) != null) {
            this.addBaseTypeParts(baseType, particles);
        }
        if (javaType.isArray()) {
            return this.handleArray(xmlType, javaType);
        }
        if (xmlType != null) {
            name = xmlType.getLocalPart();
            namespace = xmlType.getNamespaceURI();
        } else {
            name = this.utils.getJustClassName(javaType);
            namespace = this.getNamespace(javaType);
        }
        JBossXSComplexTypeDefinition complexType = this.sutils.createXSComplexTypeDefinition(name, baseType, particles, namespace);
        QName registerQName = new QName(namespace, name);
        this.typeMapping.register(javaType, registerQName, null, null);
        this.xsModel.addXSComplexTypeDefinition(complexType);
        this.registerJavaTypeMapping(registerQName, javaType, "complexType");
        particles.addAll(this.getXSParticlesForPublicFields(namespace, javaType));
        try {
            particles.addAll(this.introspectJavaProperties(namespace, javaType, elementNames));
        }
        catch (IntrospectionException e) {
            this.log.error((Object)"Problem in introspection of the Java Type during type generation", (Throwable)e);
            throw new WSException(e);
        }
        JBossXSModelGroup group = (JBossXSModelGroup)complexType.getParticle().getTerm();
        group.setParticles(particles);
        return complexType;
    }

    private void registerJavaTypeMapping(QName registerQName, Class javaType, String scope) {
        String packageName = this.javaWsdlMapping.getPackageNameForNamespaceURI(registerQName.getNamespaceURI());
        if (packageName == null && javaType.getPackage() != null) {
            PackageMapping packageMapping = new PackageMapping(this.javaWsdlMapping);
            packageMapping.setNamespaceURI(registerQName.getNamespaceURI());
            packageMapping.setPackageType(javaType.getPackage().getName());
        }
        JavaXmlTypeMapping javaXmlTypeMapping = new JavaXmlTypeMapping(this.javaWsdlMapping);
        javaXmlTypeMapping.setJavaType(javaType.getName());
        javaXmlTypeMapping.setQNameScope(scope);
        javaXmlTypeMapping.setRootTypeQName(registerQName);
        this.javaWsdlMapping.addJavaXmlTypeMappings(javaXmlTypeMapping);
    }

    private List<XSParticle> getXSParticlesForPublicFields(String typeNamespace, Class javaType) {
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>();
        Field[] fieldArray = this.utils.getPublicFields(javaType);
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field field = fieldArray[n];
            JBossXSParticle particle = this.createFieldParticle(typeNamespace, field.getName(), field.getType(), null);
            particles.add(particle);
            ++n;
        }
        return particles;
    }

    private JBossXSTypeDefinition handleArray(QName xmlType, Class javaType) {
        String namespace;
        String name;
        JBossXSTypeDefinition xst;
        Class<?> componentType = javaType.getComponentType();
        boolean isComponentArray = componentType.isArray();
        JBossXSTypeDefinition jBossXSTypeDefinition = xst = isComponentArray ? this.handleArray(null, componentType) : this.generateType(null, componentType);
        if (xmlType != null) {
            name = xmlType.getLocalPart();
            namespace = xmlType.getNamespaceURI();
        } else if (!componentType.isPrimitive() && !isComponentArray) {
            name = new StringBuffer(String.valueOf(this.utils.getJustClassName(componentType.getName()))).append(".Array").toString();
            namespace = this.getNamespace(componentType);
        } else {
            name = new StringBuffer(String.valueOf(xst.getName())).append(".Array").toString();
            namespace = xst.getNamespace();
        }
        JBossXSParticle xsp = new JBossXSParticle();
        xsp.setTerm((XSTerm)this.sutils.createXSElementDeclaration("value", xst, !componentType.isPrimitive()));
        xsp.setMaxOccurs(-1);
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>();
        particles.add(xsp);
        JBossXSComplexTypeDefinition complex = this.sutils.createXSComplexTypeDefinition(name, null, particles, namespace);
        this.xsModel.addXSComplexTypeDefinition(complex);
        this.typeMapping.register(javaType, new QName(namespace, name), null, null);
        return complex;
    }

    private List<XSParticle> introspectJavaProperties(String typeNamespace, Class javaType, Map<String, QName> elementNames) throws IntrospectionException {
        ArrayList<XSParticle> xsparts = new ArrayList<XSParticle>();
        Class superClass = javaType.getSuperclass();
        BeanInfo beanInfo = Introspector.getBeanInfo(javaType, superClass);
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        int len = props != null ? props.length : 0;
        int i = 0;
        while (i < len && !(class$javax$ejb$SessionBean == null ? SchemaTypeCreator.class$("javax.ejb.SessionBean") : class$javax$ejb$SessionBean).isAssignableFrom(javaType)) {
            PropertyDescriptor prop = props[i];
            String fieldname = prop.getName();
            Class<?> fieldType = prop.getPropertyType();
            if (this.utils.doesPublicFieldExist(javaType, fieldname)) {
                throw new WSException(new StringBuffer("Class ").append(javaType.getName()).append(" has a public field & property :").append(fieldname).toString());
            }
            JBossXSParticle particle = this.createFieldParticle(typeNamespace, fieldname, fieldType, elementNames);
            xsparts.add(particle);
            ++i;
        }
        return xsparts;
    }

    private JBossXSParticle createFieldParticle(String typeNamespace, String fieldName, Class fieldType, Map<String, QName> elementNames) {
        JBossXSElementDeclaration xsel;
        QName name;
        boolean isArray;
        boolean bl = fieldType.isArray() && fieldType != (array$B == null ? (array$B = SchemaTypeCreator.class$("[B")) : array$B) ? true : (isArray = false);
        if (isArray) {
            fieldType = fieldType.getComponentType();
        }
        JBossXSTypeDefinition xst = this.generateType(null, fieldType);
        String elementNamespace = null;
        if (elementNames != null && (name = elementNames.get(fieldName)) != null) {
            fieldName = name.getLocalPart();
            elementNamespace = name.getNamespaceURI();
            if (typeNamespace.equals(elementNamespace)) {
                elementNamespace = null;
            }
        }
        if (elementNamespace == null || elementNamespace.length() == 0) {
            xsel = this.sutils.createXSElementDeclaration(fieldName, xst, !fieldType.isPrimitive());
        } else {
            xsel = this.sutils.createGlobalXSElementDeclaration(fieldName, xst, elementNamespace);
            this.xsModel.addXSElementDeclaration(xsel);
        }
        JBossXSParticle particle = this.sutils.createXSParticle(typeNamespace, isArray, (XSTerm)xsel);
        return particle;
    }

    private void addBaseTypeParts(XSTypeDefinition baseType, List xsparts) {
        if (baseType == null) {
            throw new IllegalArgumentException("Illegal Null Argument:baseType");
        }
        if (15 == baseType.getTypeCategory()) {
            XSParticle part;
            XSTerm term;
            XSTypeDefinition btype = baseType.getBaseType();
            if (btype != null) {
                this.addBaseTypeParts(btype, xsparts);
            }
            if ((term = (part = ((XSComplexTypeDefinition)baseType).getParticle()).getTerm()) instanceof XSModelGroup) {
                JBossXSParticle p = new JBossXSParticle();
                p.setTerm(term);
                xsparts.add(p);
            }
        }
    }

    private String getNamespace(Class javaType) {
        Package javaPackage = javaType.getPackage();
        if (javaPackage == null) {
            throw new WSException("Cannot determine namespace, Class had no package");
        }
        String packageName = javaPackage.getName();
        String ns = this.packageNamespaceMap.get(packageName);
        if (ns == null) {
            ns = this.utils.getTypeNamespace(packageName);
        }
        this.allocatePrefix(ns);
        return ns;
    }

    private JBossXSComplexTypeDefinition getComplexTypeForJavaException(QName xmlType, Class javaType) {
        String name;
        String namespace;
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaTypeCreator.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(javaType)) {
            throw new IllegalArgumentException("Type is not an excpetion");
        }
        if ((class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = SchemaTypeCreator.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).isAssignableFrom(javaType)) {
            throw new IllegalArgumentException(new StringBuffer("JAX-RPC violation, the following exception extends RuntimeException: ").append(javaType.getName()).toString());
        }
        if (xmlType != null) {
            namespace = xmlType.getNamespaceURI();
            name = xmlType.getLocalPart();
        } else {
            namespace = this.getNamespace(javaType);
            name = this.utils.getJustClassName(javaType);
        }
        JBossXSComplexTypeDefinition complexType = new JBossXSComplexTypeDefinition();
        complexType.setName(name);
        complexType.setNamespace(namespace);
        Class superClass = javaType.getSuperclass();
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaTypeCreator.class$("java.lang.Exception")) : class$java$lang$Exception).equals(superClass) || (class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaTypeCreator.class$("java.lang.Throwable")) : class$java$lang$Throwable).equals(superClass)) {
            JBossXSTypeDefinition baseType = this.generateType(null, superClass);
            complexType.setBaseType(baseType);
        }
        ArrayList<Class> types = new ArrayList<Class>(0);
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>(0);
        this.generateExceptionParticles(namespace, javaType, types, particles);
        boolean found = this.hasConstructor(javaType, types);
        if (!found) {
            ArrayList<Class> newTypes = new ArrayList<Class>(types);
            newTypes.add(0, class$java$lang$String == null ? (class$java$lang$String = SchemaTypeCreator.class$("java.lang.String")) : class$java$lang$String);
            found = this.hasConstructor(javaType, newTypes);
            if (!found) {
                throw new IllegalArgumentException(new StringBuffer("Could not locate a constructor with the following types: ").append(javaType).append(' ').append(types).toString());
            }
            this.insertBaseParticle(particles, "message", class$java$lang$String == null ? (class$java$lang$String = SchemaTypeCreator.class$("java.lang.String")) : class$java$lang$String, namespace);
        }
        complexType.setParticle(this.createGroupParticle(namespace, particles));
        this.xsModel.addXSComplexTypeDefinition(complexType);
        this.xsModel.addXSElementDeclaration(this.sutils.createGlobalXSElementDeclaration(name, complexType, namespace));
        this.typeMapping.register(javaType, new QName(namespace, name), null, null);
        this.registerJavaTypeMapping(new QName(namespace, name), javaType, "complexType");
        return complexType;
    }

    private void insertBaseParticle(List<XSParticle> particles, String name, Class type, String targetNS) {
        if (particles.size() == 0) {
            particles.add(this.getXSParticle(name, type, targetNS));
            return;
        }
        XSParticle particle = particles.get(0);
        XSTerm term = particle.getTerm();
        if (term.getType() == 7) {
            XSModelGroup group = (XSModelGroup)term;
            XSObjectList list = group.getParticles();
            ArrayList<XSParticle> baseParticles = new ArrayList<XSParticle>();
            int i = 0;
            while (i < list.getLength()) {
                baseParticles.add((XSParticle)list.item(i));
                ++i;
            }
            this.insertBaseParticle(baseParticles, name, type, targetNS);
        } else {
            particles.add(0, this.getXSParticle(name, type, targetNS));
        }
    }

    private boolean hasConstructor(Class javaType, List<Class> types) {
        boolean found = true;
        try {
            javaType.getConstructor(types.toArray(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            found = false;
        }
        return found;
    }

    private void generateExceptionParticles(String typeNamespace, Class javaType, List<Class> types, List<XSParticle> particles) {
        Class superClass;
        if ((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaTypeCreator.class$("java.lang.Exception")) : class$java$lang$Exception).equals(javaType)) {
            return;
        }
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaTypeCreator.class$("java.lang.Exception")) : class$java$lang$Exception).equals(superClass = javaType.getSuperclass())) {
            ArrayList<XSParticle> superParticles = new ArrayList<XSParticle>(0);
            this.generateExceptionParticles(typeNamespace, superClass, types, superParticles);
            particles.add(this.createGroupParticle(typeNamespace, superParticles));
        }
        TreeMap sortedGetters = new TreeMap();
        Method[] methodArray = javaType.getDeclaredMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method method = methodArray[n];
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) {
                String name = method.getName();
                Class<?> returnType = method.getReturnType();
                if (name.startsWith("get") && returnType != Void.TYPE) {
                    name = Introspector.decapitalize(name.substring(3));
                    sortedGetters.put(name, returnType);
                }
            }
            ++n;
        }
        for (String name : sortedGetters.keySet()) {
            Class type = (Class)sortedGetters.get(name);
            types.add(type);
            JBossXSParticle particle = this.createFieldParticle(typeNamespace, name, type, null);
            particles.add(particle);
        }
    }

    private JBossXSParticle createGroupParticle(String targetNS, List<XSParticle> memberParticles) {
        JBossXSParticle groupParticle = new JBossXSParticle(null, targetNS);
        JBossXSModelGroup group = new JBossXSModelGroup();
        group.setParticles(memberParticles, false);
        groupParticle.setTerm((XSTerm)group);
        return groupParticle;
    }

    private JBossXSParticle getXSParticle(String name, Class fieldType, String targetNS) {
        JBossXSTypeDefinition xstype = null;
        boolean isArray = fieldType.isArray();
        if (isArray) {
            fieldType = fieldType.getComponentType();
        }
        xstype = this.generateType(null, fieldType);
        boolean isNillable = !fieldType.isPrimitive();
        JBossXSElementDeclaration xsel = this.sutils.createXSElementDeclaration(name, xstype, isNillable);
        return this.sutils.createXSParticle(targetNS, isArray, (XSTerm)xsel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

