/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.HashMap;
import net.sf.retrotranslator.runtime.java.lang._Byte;
import net.sf.retrotranslator.runtime.java.lang._Double;
import net.sf.retrotranslator.runtime.java.lang._Float;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._Long;
import net.sf.retrotranslator.runtime.java.lang._Short;
import org.jboss.logging.Logger;

public class JavaUtils {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$utils$JavaUtils == null ? (class$org$jboss$ws$utils$JavaUtils = JavaUtils.class$("org.jboss.ws.utils.JavaUtils")) : class$org$jboss$ws$utils$JavaUtils));
    private static HashMap<String, Class> primitiveNames = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;
    static /* synthetic */ Class class$31;
    static /* synthetic */ Class class$32;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$Ljava$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class class$org$jboss$ws$utils$JavaUtils;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$Ljava$lang$Double;

    static {
        primitiveNames.put("int", Integer.TYPE);
        primitiveNames.put("short", Short.TYPE);
        primitiveNames.put("boolean", Boolean.TYPE);
        primitiveNames.put("byte", Byte.TYPE);
        primitiveNames.put("long", Long.TYPE);
        primitiveNames.put("double", Double.TYPE);
        primitiveNames.put("float", Float.TYPE);
        primitiveNames.put("char", Character.TYPE);
    }

    public static Class loadJavaType(String typeName) throws ClassNotFoundException {
        return JavaUtils.loadJavaType(typeName, null);
    }

    public static Class loadJavaType(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> javaType;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((javaType = primitiveNames.get(typeName)) == null) {
            javaType = JavaUtils.getArray(typeName, classLoader);
        }
        if (javaType == null) {
            javaType = classLoader.loadClass(typeName);
        }
        return javaType;
    }

    public static boolean isPrimitive(String javaType) {
        return JavaUtils.getPrimitiveType(javaType) != null;
    }

    public static boolean isPrimitive(Class javaType) {
        return javaType.isPrimitive() || javaType.isArray() && JavaUtils.isPrimitive(javaType.getComponentType());
    }

    public static Class getPrimitiveType(String javaType) {
        Class type = primitiveNames.get(javaType);
        if (type != null) {
            return type;
        }
        try {
            type = JavaUtils.getArray(javaType, null);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return type;
    }

    private static Class getArray(String javaType, ClassLoader loader) throws ClassNotFoundException {
        if (javaType.charAt(0) == '[') {
            return JavaUtils.getArrayFromJVMName(javaType, loader);
        }
        if (javaType.endsWith("[]")) {
            return JavaUtils.getArrayFromSourceName(javaType, loader);
        }
        return null;
    }

    private static Class getArrayFromJVMName(String javaType, ClassLoader loader) throws ClassNotFoundException {
        Class<Constable> componentType;
        int componentStart = javaType.lastIndexOf(91) + 1;
        switch (javaType.charAt(componentStart)) {
            case 'I': {
                componentType = Integer.TYPE;
                break;
            }
            case 'S': {
                componentType = Short.TYPE;
                break;
            }
            case 'Z': {
                componentType = Boolean.TYPE;
                break;
            }
            case 'B': {
                componentType = Byte.TYPE;
                break;
            }
            case 'J': {
                componentType = Long.TYPE;
                break;
            }
            case 'D': {
                componentType = Double.TYPE;
                break;
            }
            case 'F': {
                componentType = Float.TYPE;
                break;
            }
            case 'C': {
                componentType = Character.TYPE;
                break;
            }
            case 'L': {
                if (loader == null) {
                    return null;
                }
                String name = javaType.substring(componentStart + 1, javaType.length() - 1);
                componentType = loader.loadClass(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid binary component for array: " + javaType.charAt(componentStart));
            }
        }
        return Array.newInstance(componentType, new int[componentStart]).getClass();
    }

    private static Class getArrayFromSourceName(String javaType, ClassLoader loader) throws ClassNotFoundException {
        int arrayStart = javaType.indexOf(91);
        String componentName = javaType.substring(0, arrayStart);
        Class<?> componentType = primitiveNames.get(componentName);
        if (componentType == null) {
            if (loader == null) {
                return null;
            }
            componentType = loader.loadClass(componentName);
        }
        int dimensions = javaType.length() - arrayStart >> 1;
        return Array.newInstance(componentType, new int[dimensions]).getClass();
    }

    public static Class getPrimitiveType(Class javaType) {
        if (javaType == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (javaType == (class$java$lang$Short == null ? (class$java$lang$Short = JavaUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        if (javaType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (javaType == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (javaType == (class$java$lang$Long == null ? (class$java$lang$Long = JavaUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (javaType == (class$java$lang$Double == null ? (class$java$lang$Double = JavaUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (javaType == (class$java$lang$Float == null ? (class$java$lang$Float = JavaUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (javaType == (class$java$lang$Character == null ? (class$java$lang$Character = JavaUtils.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (javaType == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = JavaUtils.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer)) {
            return array$I == null ? (array$I = JavaUtils.class$("[I")) : array$I;
        }
        if (javaType == (array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = JavaUtils.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short)) {
            return array$S == null ? (array$S = JavaUtils.class$("[S")) : array$S;
        }
        if (javaType == (array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = JavaUtils.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean)) {
            return array$Z == null ? (array$Z = JavaUtils.class$("[Z")) : array$Z;
        }
        if (javaType == (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = JavaUtils.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte)) {
            return array$B == null ? (array$B = JavaUtils.class$("[B")) : array$B;
        }
        if (javaType == (array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = JavaUtils.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long)) {
            return array$J == null ? (array$J = JavaUtils.class$("[J")) : array$J;
        }
        if (javaType == (array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = JavaUtils.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double)) {
            return array$D == null ? (array$D = JavaUtils.class$("[D")) : array$D;
        }
        if (javaType == (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = JavaUtils.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float)) {
            return array$F == null ? (array$F = JavaUtils.class$("[F")) : array$F;
        }
        if (javaType == (array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = JavaUtils.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character)) {
            return array$C == null ? (array$C = JavaUtils.class$("[C")) : array$C;
        }
        if (javaType.isArray() && javaType.getComponentType().isArray()) {
            Class compType = JavaUtils.getPrimitiveType(javaType.getComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return javaType;
    }

    public static Object getPrimitiveValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> javaType = value.getClass();
        if (javaType == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return _Integer.valueOf((int)((Integer)value));
        }
        if (javaType == (class$java$lang$Short == null ? (class$java$lang$Short = JavaUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return _Short.valueOf((short)((Short)value));
        }
        if (javaType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return (boolean)((Boolean)value);
        }
        if (javaType == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return _Byte.valueOf((byte)((Byte)value));
        }
        if (javaType == (class$java$lang$Long == null ? (class$java$lang$Long = JavaUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return _Long.valueOf((long)((Long)value));
        }
        if (javaType == (class$java$lang$Double == null ? (class$java$lang$Double = JavaUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return _Double.valueOf((double)((Double)value));
        }
        if (javaType == (class$java$lang$Float == null ? (class$java$lang$Float = JavaUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return _Float.valueOf((float)((Float)value).floatValue());
        }
        if (javaType.isArray()) {
            int length = Array.getLength(value);
            Object destArr = Array.newInstance(JavaUtils.getPrimitiveType(javaType.getComponentType()), length);
            int i = 0;
            while (i < length) {
                Object srcObj = Array.get(value, i);
                Object destObj = JavaUtils.getPrimitiveValue(srcObj);
                Array.set(destArr, i, destObj);
                ++i;
            }
            return destArr;
        }
        return value;
    }

    public static Class getWrapperType(Class javaType) {
        if (javaType == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = JavaUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (javaType == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = JavaUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (javaType == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (javaType == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = JavaUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (javaType == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = JavaUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (javaType == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = JavaUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (javaType == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = JavaUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (javaType == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = JavaUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (javaType == (array$I == null ? (array$I = JavaUtils.class$("[I")) : array$I)) {
            return array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = JavaUtils.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer;
        }
        if (javaType == (array$S == null ? (array$S = JavaUtils.class$("[S")) : array$S)) {
            return array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = JavaUtils.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short;
        }
        if (javaType == (array$Z == null ? (array$Z = JavaUtils.class$("[Z")) : array$Z)) {
            return array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = JavaUtils.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean;
        }
        if (javaType == (array$B == null ? (array$B = JavaUtils.class$("[B")) : array$B)) {
            return array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = JavaUtils.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte;
        }
        if (javaType == (array$J == null ? (array$J = JavaUtils.class$("[J")) : array$J)) {
            return array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = JavaUtils.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long;
        }
        if (javaType == (array$D == null ? (array$D = JavaUtils.class$("[D")) : array$D)) {
            return array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = JavaUtils.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double;
        }
        if (javaType == (array$F == null ? (array$F = JavaUtils.class$("[F")) : array$F)) {
            return array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = JavaUtils.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float;
        }
        if (javaType == (array$C == null ? (array$C = JavaUtils.class$("[C")) : array$C)) {
            return array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = JavaUtils.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character;
        }
        if (javaType.isArray() && javaType.getComponentType().isArray()) {
            Class compType = JavaUtils.getWrapperType(javaType.getComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return javaType;
    }

    public static Object getWrapperValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> javaType = value.getClass();
        if (javaType == Integer.TYPE) {
            return Integer.valueOf("" + value);
        }
        if (javaType == Short.TYPE) {
            return Short.valueOf("" + value);
        }
        if (javaType == Boolean.TYPE) {
            return Boolean.valueOf("" + value);
        }
        if (javaType == Byte.TYPE) {
            return Byte.valueOf("" + value);
        }
        if (javaType == Long.TYPE) {
            return Long.valueOf("" + value);
        }
        if (javaType == Double.TYPE) {
            return Double.valueOf("" + value);
        }
        if (javaType == Float.TYPE) {
            return Float.valueOf("" + value);
        }
        if (javaType.isArray()) {
            int length = Array.getLength(value);
            Object destArr = Array.newInstance(JavaUtils.getWrapperType(javaType.getComponentType()), length);
            int i = 0;
            while (i < length) {
                Object srcObj = Array.get(value, i);
                Object destObj = JavaUtils.getWrapperValue(srcObj);
                Array.set(destArr, i, destObj);
                ++i;
            }
            return destArr;
        }
        return value;
    }

    public static boolean isAssignableFrom(Class dest, Class src) {
        if (dest == null) {
            throw new IllegalArgumentException("Destination class cannot be null");
        }
        if (src == null) {
            throw new IllegalArgumentException("Source class cannot be null");
        }
        boolean isAssignable = dest.isAssignableFrom(src);
        if (!isAssignable && dest.getName().equals(src.getName())) {
            ClassLoader destLoader = dest.getClassLoader();
            ClassLoader srcLoader = src.getClassLoader();
            log.debug((Object)("Not assignable because of conflicting class loaders:\ndstLoader=" + destLoader + "\nsrcLoader=" + srcLoader));
        }
        if (!isAssignable && JavaUtils.isPrimitive(dest)) {
            dest = JavaUtils.getWrapperType(dest);
            isAssignable = dest.isAssignableFrom(src);
        }
        if (!isAssignable && JavaUtils.isPrimitive(src)) {
            src = JavaUtils.getWrapperType(src);
            isAssignable = dest.isAssignableFrom(src);
        }
        return isAssignable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

