/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class PrettyPrinter {
    private OutputStream out;
    private Writer writer;
    private XMLSerializer elementSerializer;
    private OutputFormat format = new OutputFormat("xml", "utf-8", true);

    private PrettyPrinter() {
        this.format.setIndent(2);
        this.format.setLineWidth(65);
        this.format.setOmitXMLDeclaration(true);
    }

    public PrettyPrinter(OutputStream out) {
        this();
        this.out = out;
        this.elementSerializer = new XMLSerializer(out, this.format);
    }

    public PrettyPrinter(Writer writer) {
        this();
        this.writer = writer;
        this.elementSerializer = new XMLSerializer(writer, this.format);
    }

    public void print(Element element) {
        try {
            this.elementSerializer.serialize(element);
        }
        catch (Exception exception) {}
    }

    public void print(DocumentFragment fragment) {
        try {
            this.elementSerializer.serialize(fragment);
        }
        catch (Exception exception) {}
    }

    public void print(Document document) {
        try {
            OutputFormat format = new OutputFormat(document);
            format.setIndent(2);
            format.setLineWidth(65);
            XMLSerializer serializer = new XMLSerializer(this.out, format);
            serializer.serialize(document);
        }
        catch (Exception exception) {}
    }

    public static String printToString(Document document) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrettyPrinter printer = new PrettyPrinter(stream);
        printer.print(document);
        return stream.toString();
    }

    public static String printToString(Element element) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrettyPrinter printer = new PrettyPrinter(stream);
        printer.print(element);
        return stream.toString();
    }
}

