/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import net.sf.retrotranslator.runtime.java.lang._String;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.jaxrpc.encoding.SimpleDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.SimpleSerializerFactory;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.utils.JavaUtils;

public class ToolsUtils {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$utils$ToolsUtils == null ? (class$org$jboss$ws$utils$ToolsUtils = ToolsUtils.class$("org.jboss.ws.utils.ToolsUtils")) : class$org$jboss$ws$utils$ToolsUtils));
    private static LiteralTypeMapping mapping = new LiteralTypeMapping();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$jboss$ws$utils$ToolsUtils;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ByteArrayHolder;

    private ToolsUtils() {
        throw new WSException("Cannot instantiate ToolsUtils.");
    }

    public static void checkParameterType(Class paramType) {
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ToolsUtils.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(paramType)) {
            throw new IllegalArgumentException("JAXWS-2.0 Assertion::Method param shouldn't extend Remote");
        }
    }

    public static String firstLetterUpperCase(String fname) {
        if (fname == "" || fname == null) {
            throw new WSException("String passed is null");
        }
        if (Character.isLowerCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toUpperCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public static String firstLetterLowerCase(String fname) {
        if (fname == "" || fname == null) {
            throw new WSException("String passed is null");
        }
        if (Character.isUpperCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toLowerCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public static String getFormattedStringForArray(Class arr) {
        if (arr == null) {
            throw new IllegalArgumentException("Illegal null argument:arr");
        }
        if (!arr.isArray()) {
            throw new IllegalArgumentException("Illegal argument:arr is not an array");
        }
        int dim = WSDLUtils.getInstance().getArrayDimension(arr);
        Class<?> cls = arr;
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        String clname = cls.getName();
        int i = 0;
        while (i < dim) {
            clname = String.valueOf(clname) + "[]";
            ++i;
        }
        return clname;
    }

    public static String getJavaPackageName(String targetNS) {
        String token;
        int ind;
        if (targetNS == null) {
            throw new IllegalArgumentException("TargetNS is null");
        }
        String pkgName = null;
        if (!targetNS.startsWith("http") && !targetNS.startsWith("urn")) {
            throw new IllegalArgumentException("TargetNS should start with http/https/urn");
        }
        if ((targetNS = targetNS.substring(targetNS.indexOf(":") + 1)).startsWith("//www")) {
            targetNS = targetNS.substring(6);
        }
        if (targetNS.endsWith("/")) {
            targetNS = targetNS.substring(0, targetNS.lastIndexOf("/"));
        }
        if ((ind = targetNS.lastIndexOf("/")) > 0) {
            String first = targetNS.substring(0, ind);
            String subs = targetNS.substring(ind + 1);
            int dotindex = subs.lastIndexOf(".");
            if (dotindex > -1) {
                subs = subs.substring(0, dotindex);
            }
            targetNS = String.valueOf(first) + "." + subs;
        }
        pkgName = _String.replace((String)targetNS, (CharSequence)"/", (CharSequence)".");
        pkgName = _String.replace((String)pkgName, (CharSequence)"-", (CharSequence)".");
        if ((pkgName = _String.replace((String)pkgName, (CharSequence)":", (CharSequence)".")).startsWith("..")) {
            pkgName = pkgName.substring(2);
        }
        StringTokenizer st = new StringTokenizer(pkgName, ".");
        ArrayList<String> lst = new ArrayList<String>();
        String toplevel = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if ("net".equals(token) || "org".equals(token) || "edu".equals(token) || "gov".equals(token)) {
                toplevel = token;
                continue;
            }
            lst.add(token);
        }
        lst.size();
        pkgName = toplevel != null ? toplevel : "";
        Iterator iterator = lst.iterator();
        while (iterator.hasNext()) {
            token = (String)iterator.next();
            if (Character.isDigit(token.charAt(0))) {
                token = "_" + token;
            }
            pkgName = pkgName == "" ? String.valueOf(pkgName) + token : String.valueOf(pkgName) + "." + token;
        }
        return pkgName;
    }

    public static String getJavaIdentifier(String xmlName) {
        if (xmlName == null || xmlName == "") {
            throw new IllegalArgumentException("xmlName is null");
        }
        xmlName = xmlName.trim();
        if ((xmlName = ToolsUtils.trimPunctuationMarks(xmlName)) == null) {
            throw new WSException("xmlName has become null");
        }
        int lenStr = xmlName.length();
        char[] mainArr = new char[lenStr];
        int j = 0;
        int i = 0;
        while (i < lenStr) {
            char ch = xmlName.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                mainArr[j] = ch;
                ++j;
            }
            ++i;
        }
        char[] secArr = new char[j];
        int x = 0;
        while (x < j) {
            secArr[x] = mainArr[x];
            ++x;
        }
        return new String(secArr);
    }

    public static String getJavaMethodName(String xmlName, boolean setter) {
        xmlName = ToolsUtils.getJavaIdentifier(xmlName);
        xmlName = ToolsUtils.firstLetterUpperCase(xmlName);
        String lcase = xmlName.toLowerCase();
        if (setter && !lcase.startsWith("set")) {
            xmlName = "set" + xmlName;
        } else if (!setter && !lcase.startsWith("get")) {
            xmlName = "get" + xmlName;
        }
        return ToolsUtils.firstLetterLowerCase(xmlName);
    }

    public static String getValidClassName(String xmlName) {
        xmlName = ToolsUtils.getJavaIdentifier(xmlName);
        return ToolsUtils.firstLetterUpperCase(xmlName);
    }

    public static QName getXMLType(Class javaClass, String ns) {
        WSDLUtils utils = WSDLUtils.getInstance();
        QName xmlType = null;
        if (Void.TYPE == javaClass) {
            return null;
        }
        if ((class$javax$xml$rpc$holders$ByteArrayHolder == null ? (class$javax$xml$rpc$holders$ByteArrayHolder = ToolsUtils.class$("javax.xml.rpc.holders.ByteArrayHolder")) : class$javax$xml$rpc$holders$ByteArrayHolder) == javaClass) {
            return Constants.TYPE_LITERAL_BASE64BINARY;
        }
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = ToolsUtils.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        if ((xmlType = SchemaUtils.getInstance().getToolsOverrideInTypeMapping(javaClass)) != null) {
            return xmlType;
        }
        xmlType = mapping.getXMLType(javaClass, false);
        if (xmlType != null) {
            return xmlType;
        }
        String typeName = utils.getJustClassName(javaClass);
        if (javaClass.isArray()) {
            int dim = utils.getArrayDimension(javaClass);
            Class<?> cls = javaClass;
            while (cls.isArray()) {
                cls = cls.getComponentType();
            }
            typeName = WSDLUtils.getInstance().getJustClassName(cls);
            while (dim-- > 0) {
                typeName = String.valueOf(typeName) + ".Array";
            }
        }
        return new QName(ns, typeName);
    }

    public static QName getXMLTypeForAttachmentType(String mimetype) {
        return Constants.TYPE_LITERAL_HEXBINARY;
    }

    public static boolean isPunctuation(char c) {
        boolean ret = true;
        if (Character.isDigit(c)) {
            ret = false;
        } else if (Character.isLetter(c)) {
            ret = false;
        } else if (Character.isISOControl(c)) {
            ret = false;
        } else if (Character.isWhitespace(c)) {
            ret = false;
        }
        return ret;
    }

    public static boolean isJaxrpcValueType(Class cls) {
        boolean result = true;
        if (ToolsUtils.isJaxrpcRegularType(cls)) {
            return false;
        }
        boolean defaultCTR = false;
        Constructor<?>[] cons = cls.getDeclaredConstructors();
        int i = 0;
        while (i < cons.length) {
            Class<?>[] paramTypes = cons[i].getParameterTypes();
            if (paramTypes == null || paramTypes.length == 0) {
                defaultCTR = true;
                break;
            }
            ++i;
        }
        if (!defaultCTR) {
            return false;
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ToolsUtils.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cls)) {
            return false;
        }
        Field[] fieldArr = cls.getDeclaredFields();
        int length = Array.getLength(fieldArr);
        int i2 = 0;
        while (i2 < length) {
            if (!ToolsUtils.isJaxrpcPermittedType(fieldArr[i2].getType())) {
                return false;
            }
            ++i2;
        }
        return result;
    }

    public static boolean isJavaBean(Class cls) {
        boolean result = false;
        if (ToolsUtils.isJaxrpcRegularType(cls)) {
            return false;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            if (pds != null && pds.length > 0) {
                result = true;
            }
        }
        catch (IntrospectionException introspectionException) {}
        return result;
    }

    public static int getNumberOfParticles(Class javaBean) {
        if (!ToolsUtils.isJavaBean(javaBean)) {
            throw new IllegalArgumentException("Illegal JavaBean argument");
        }
        Field[] pubFields = javaBean.getFields();
        int pub = pubFields != null ? pubFields.length : 0;
        int props = 0;
        try {
            BeanInfo bi = Introspector.getBeanInfo(javaBean);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            props = pds != null ? Array.getLength(pds) : 0;
            int len = 0;
            int i = 0;
            while (i < props) {
                PropertyDescriptor pd = pds[i];
                Method readMethod = pd.getReadMethod();
                if (!"getClass".equals(readMethod.getName())) {
                    ++len;
                }
                ++i;
            }
            props = len;
        }
        catch (IntrospectionException introspectionException) {}
        return pub + props;
    }

    public static boolean canUnWrap(Class javaType, boolean isReturnType) {
        boolean bool = false;
        bool = isReturnType ? ToolsUtils.isJavaBean(javaType) && ToolsUtils.getNumberOfParticles(javaType) == 1 : ToolsUtils.isJaxrpcValueType(javaType);
        return bool;
    }

    public static boolean isJaxrpcPermittedType(Class type) {
        if (!ToolsUtils.isJaxrpcRegularType(type)) {
            return ToolsUtils.isJaxrpcValueType(type);
        }
        return true;
    }

    public static boolean isJaxrpcRegularType(Class type) {
        boolean result = false;
        if (JavaUtils.isPrimitive(type)) {
            return true;
        }
        Class wrapperType = JavaUtils.getWrapperType(type);
        if (wrapperType != null && wrapperType != type) {
            return true;
        }
        Class primType = JavaUtils.getPrimitiveType(type);
        if (primType != null && primType != type) {
            return true;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = ToolsUtils.class$("java.lang.String")) : class$java$lang$String) == type || (class$java$util$Date == null ? (class$java$util$Date = ToolsUtils.class$("java.util.Date")) : class$java$util$Date) == type || (class$java$util$Calendar == null ? (class$java$util$Calendar = ToolsUtils.class$("java.util.Calendar")) : class$java$util$Calendar) == type || (class$java$math$BigInteger == null ? (class$java$math$BigInteger = ToolsUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger) == type || (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ToolsUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) == type || (class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ToolsUtils.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName) == type || (class$java$net$URI == null ? (class$java$net$URI = ToolsUtils.class$("java.net.URI")) : class$java$net$URI) == type) {
            return true;
        }
        return result;
    }

    public static synchronized void registerJavaType(LiteralTypeMapping typeMapping, Class clazz, QName xmlType) {
        if (!typeMapping.isRegistered(clazz, xmlType)) {
            typeMapping.register(clazz, xmlType, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        }
    }

    private static String trimPunctuationMarks(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Str is null");
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            str = str.substring(1);
        } else if (ToolsUtils.isPunctuation(str.charAt(0))) {
            str = str.substring(1);
        }
        int len = str.length();
        if (ToolsUtils.isPunctuation(str.charAt(len - 1))) {
            str = str.substring(0, len - 1);
        }
        return str;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

