/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.security.SecureRandom;

public class UUIDGenerator {
    private static SecureRandom rand;

    private static String bytesToHex(byte[] buffer, int offset, int length) {
        long value = 0L;
        int i = 0;
        int countDown = 8 * length;
        while (i < length) {
            value |= ((long)buffer[offset + i] & 0xFFL) << (countDown -= 8);
            ++i;
        }
        return Long.toHexString(value);
    }

    public static byte[] generateRandomUUIDBytes() {
        if (rand == null) {
            rand = new SecureRandom();
        }
        byte[] buffer = new byte[16];
        rand.nextBytes(buffer);
        buffer[6] = (byte)(buffer[6] & 0xF | 0x40);
        buffer[8] = (byte)(buffer[8] & 0x3F | 0x80);
        return buffer;
    }

    public static String generateRandomUUIDString() {
        return UUIDGenerator.convertToString(UUIDGenerator.generateRandomUUIDBytes());
    }

    public static String convertToString(byte[] uuid) {
        if (uuid.length != 16) {
            throw new IllegalArgumentException("A UUID must be 16 bytes!");
        }
        String string = String.valueOf(UUIDGenerator.bytesToHex(uuid, 0, 4)) + "-" + UUIDGenerator.bytesToHex(uuid, 4, 2) + "-" + UUIDGenerator.bytesToHex(uuid, 6, 2) + "-" + UUIDGenerator.bytesToHex(uuid, 8, 2) + "-" + UUIDGenerator.bytesToHex(uuid, 10, 6);
        return string;
    }
}

