/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import java.security.Key;
import java.util.Collection;
import java.util.HashSet;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.jboss.ws.wsse.DecodingOperation;
import org.jboss.ws.wsse.FailedCheckException;
import org.jboss.ws.wsse.InvalidSecurityHeaderException;
import org.jboss.ws.wsse.SecurityStore;
import org.jboss.ws.wsse.Util;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.element.EncryptedKey;
import org.jboss.ws.wsse.element.ReferenceList;
import org.jboss.ws.wsse.element.SecurityHeader;
import org.jboss.ws.wsse.element.SecurityProcess;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptionOperation
implements DecodingOperation {
    private SecurityHeader header;
    private SecurityStore store;

    public DecryptionOperation(SecurityHeader header, SecurityStore store) throws WSSecurityException {
        this.header = header;
        this.store = store;
    }

    private boolean isContent(Element element) {
        return "http://www.w3.org/2001/04/xmlenc#Content".equals(element.getAttribute("Type"));
    }

    private String getEncryptionAlgorithm(Element element) throws WSSecurityException {
        if ((element = Util.findElement(element, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#")) == null) {
            throw new InvalidSecurityHeaderException("Encrypted element corrupted, no encryption method");
        }
        String alg = element.getAttribute("Algorithm");
        if (alg == null || alg.length() == 0) {
            throw new InvalidSecurityHeaderException("Encrypted element corrupted, no algorithm specified");
        }
        return alg;
    }

    private String decryptElement(Element element, SecretKey key) throws WSSecurityException {
        Element decrypted;
        Element previous;
        boolean isContent = this.isContent(element);
        boolean parent = isContent;
        if (parent) {
            previous = (Element)element.getParentNode();
        } else {
            previous = Util.getPreviousSiblingElement(element);
            if (previous == null) {
                parent = true;
                previous = (Element)element.getParentNode();
            }
        }
        String alg = this.getEncryptionAlgorithm(element);
        try {
            XMLCipher cipher = XMLCipher.getInstance((String)alg);
            cipher.init(2, (Key)key);
            cipher.doFinal(element.getOwnerDocument(), element);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new FailedCheckException("Decryption was invalid.");
        }
        catch (Exception e) {
            throw new WSSecurityException(new StringBuffer("Could not decrypt element: ").append(e.getMessage()).toString(), e);
        }
        if (isContent) {
            return Util.getWsuId(previous);
        }
        Element element2 = decrypted = parent ? Util.getFirstChildElement(previous) : Util.getNextSiblingElement(previous);
        if (decrypted == null) {
            return null;
        }
        return Util.getWsuId(decrypted);
    }

    private boolean isEncryptedData(Element element) {
        return "EncryptedData".equals(element.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI());
    }

    @Override
    public Collection<String> process(Document message, SecurityProcess process) throws WSSecurityException {
        HashSet<String> ids = new HashSet<String>();
        EncryptedKey key = (EncryptedKey)process;
        ReferenceList list = key.getReferenceList();
        for (String uri : list.getAllReferences()) {
            Element element = Util.findElementByWsuId(message.getDocumentElement(), uri);
            if (element == null) {
                throw new WSSecurityException(new StringBuffer("A reference list refered to an element that was not found: ").append(uri).toString());
            }
            if (!this.isEncryptedData(element)) {
                throw new WSSecurityException(new StringBuffer("Malformed reference list, a non encrypted data element was referenced: ").append(uri).toString());
            }
            ids.add(this.decryptElement(element, key.getSecretKey()));
        }
        return ids;
    }
}

