/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.xml.security.Init;
import org.jboss.ws.wsse.EncodingOperation;
import org.jboss.ws.wsse.OperationDescription;
import org.jboss.ws.wsse.SecurityStore;
import org.jboss.ws.wsse.Util;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.element.SecurityHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityEncoder {
    private List<OperationDescription<EncodingOperation>> operations;
    private SecurityStore store;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$org$jboss$ws$wsse$SecurityStore;
    static /* synthetic */ Class class$org$jboss$ws$wsse$element$SecurityHeader;

    public SecurityEncoder(List<OperationDescription<EncodingOperation>> operations, SecurityStore store) {
        Init.init();
        this.operations = operations;
        this.store = store;
    }

    private void attachHeader(SecurityHeader header, Document message) {
        Element soapHeader = Util.findOrCreateSoapHeader(message.getDocumentElement());
        try {
            Element wsse = header.getElement();
            wsse.setAttributeNS(soapHeader.getNamespaceURI(), new StringBuffer(String.valueOf(soapHeader.getPrefix())).append(":mustUnderstand").toString(), "1");
            soapHeader.insertBefore(wsse, soapHeader.getFirstChild());
        }
        catch (Exception exception) {}
    }

    public void encode(Document message) throws WSSecurityException {
        SecurityHeader header = new SecurityHeader(message);
        for (OperationDescription<EncodingOperation> o : this.operations) {
            EncodingOperation operation;
            try {
                Constructor<EncodingOperation> constructor = o.getOperation().getConstructor(class$org$jboss$ws$wsse$element$SecurityHeader == null ? SecurityEncoder.class$("org.jboss.ws.wsse.element.SecurityHeader") : class$org$jboss$ws$wsse$element$SecurityHeader, class$org$jboss$ws$wsse$SecurityStore == null ? SecurityEncoder.class$("org.jboss.ws.wsse.SecurityStore") : class$org$jboss$ws$wsse$SecurityStore);
                operation = constructor.newInstance(header, this.store);
            }
            catch (Exception exception) {
                throw new WSSecurityException(new StringBuffer("Error constructing operation: ").append(o.getOperation()).toString());
            }
            operation.process(message, o.getTargets(), o.getCertificateAlias(), o.getCredential(), o.getAlgorithm());
        }
        this.attachHeader(header, message);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

