/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.jboss.logging.Logger;
import org.jboss.ws.wsse.FailedAuthenticationException;
import org.jboss.ws.wsse.WSSecurityException;

public class SecurityStore {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$wsse$SecurityStore == null ? (class$org$jboss$ws$wsse$SecurityStore = SecurityStore.class$("org.jboss.ws.wsse.SecurityStore")) : class$org$jboss$ws$wsse$SecurityStore));
    private KeyStore keyStore;
    private String keyStorePassword;
    private KeyStore trustStore;
    private String trustStorePassword;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$wsse$SecurityStore;

    public SecurityStore() throws WSSecurityException {
        this(null, null, null, null, null, null);
    }

    public SecurityStore(URL keyStoreURL, String keyStoreType, String keyStorePassword) throws WSSecurityException {
        this.loadKeyStore(keyStoreURL, keyStoreType, keyStorePassword);
        this.loadTrustStore(keyStoreURL, keyStoreType, keyStorePassword);
    }

    public SecurityStore(URL keyStoreURL, String keyStoreType, String keyStorePassword, URL trustStoreURL, String trustStoreType, String trustStorePassword) throws WSSecurityException {
        this.loadKeyStore(keyStoreURL, keyStoreType, keyStorePassword);
        this.loadTrustStore(trustStoreURL, trustStoreType, trustStorePassword);
    }

    private void loadKeyStore(URL keyStoreURL, String keyStoreType, String keyStorePassword) throws WSSecurityException {
        if (keyStorePassword == null) {
            keyStorePassword = System.getProperty("org.jboss.ws.wsse.keyStorePassword");
        }
        this.keyStore = this.loadStore("org.jboss.ws.wsse.keyStore", "Keystore", keyStoreURL, keyStoreType, keyStorePassword);
        this.keyStorePassword = keyStorePassword;
    }

    private void loadTrustStore(URL trustStoreURL, String trustStoreType, String trustStorePassword) throws WSSecurityException {
        if (trustStorePassword == null) {
            trustStorePassword = System.getProperty("org.jboss.ws.wsse.trustStorePassword");
        }
        this.trustStore = this.loadStore("org.jboss.ws.wsse.trustStore", "Truststore", trustStoreURL, trustStoreType, trustStorePassword);
        this.trustStorePassword = trustStorePassword;
    }

    private KeyStore loadStore(String property, String type, URL storeURL, String storeType, String storePassword) throws WSSecurityException {
        if (storeType == null) {
            storeType = System.getProperty(String.valueOf(property) + "Type");
        }
        if (storeType == null) {
            storeType = "jks";
        }
        try {
            InputStream stream;
            if (storeURL == null) {
                String defaultStore = System.getProperty(property);
                if (defaultStore == null) {
                    throw new WSSecurityException(String.valueOf(type) + " url not specified");
                }
                stream = new FileInputStream(defaultStore);
            } else {
                stream = storeURL.openStream();
            }
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(stream, storePassword.toCharArray());
            return keyStore;
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems loading " + type + ": " + e.getMessage(), e);
        }
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate cert) {
        byte[] encoded = cert.getExtensionValue("2.5.29.14");
        if (encoded == null) {
            return null;
        }
        int trunc = encoded.length - 4;
        byte[] identifier = new byte[trunc];
        System.arraycopy(encoded, 4, identifier, 0, trunc);
        return identifier;
    }

    public X509Certificate getCertificate(String alias) throws WSSecurityException {
        X509Certificate cert;
        try {
            cert = (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
        if (cert == null) {
            throw new WSSecurityException("Certificate (" + alias + ") not in keystore");
        }
        return cert;
    }

    public X509Certificate getCertificateBySubjectKeyIdentifier(byte[] identifier) throws WSSecurityException {
        if (identifier == null) {
            return null;
        }
        try {
            Enumeration<String> i = this.keyStore.aliases();
            while (i.hasMoreElements()) {
                byte[] subjectKeyIdentifier;
                String alias = i.nextElement();
                Certificate cert = this.keyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate) || (subjectKeyIdentifier = SecurityStore.getSubjectKeyIdentifier((X509Certificate)cert)) == null || !Arrays.equals(identifier, subjectKeyIdentifier)) continue;
                return (X509Certificate)cert;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
        return null;
    }

    public X509Certificate getCertificateByIssuerSerial(String issuer, String serial) throws WSSecurityException {
        try {
            Enumeration<String> i = this.keyStore.aliases();
            while (i.hasMoreElements()) {
                X509Certificate x509;
                String alias = i.nextElement();
                Certificate cert = this.keyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate) || !issuer.equals((x509 = (X509Certificate)cert).getIssuerDN().toString()) || !serial.equals(x509.getSerialNumber().toString())) continue;
                return x509;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String alias) throws WSSecurityException {
        PrivateKey key;
        try {
            key = (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems retrieving private key: " + e.getMessage(), e);
        }
        if (key == null) {
            throw new WSSecurityException("Private key (" + alias + ") not in keystore");
        }
        return key;
    }

    public PrivateKey getPrivateKey(X509Certificate cert) throws WSSecurityException {
        try {
            String alias = this.keyStore.getCertificateAlias(cert);
            return this.getPrivateKey(alias);
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems retrieving private key: " + e.getMessage(), e);
        }
    }

    public void validateCertificate(X509Certificate cert) throws WSSecurityException {
        PKIXParameters parameters;
        CertPathValidator cpv;
        CertPath cp;
        try {
            cert.checkValidity();
        }
        catch (Exception e) {
            log.debug((Object)"Certificate is invalid", (Throwable)e);
            throw new FailedAuthenticationException();
        }
        try {
            if (this.trustStore.getCertificateAlias(cert) != null) {
                return;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems searching truststore", e);
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(1);
        list.add(cert);
        try {
            cp = CertificateFactory.getInstance("X.509").generateCertPath(list);
            cpv = CertPathValidator.getInstance("PKIX");
            parameters = new PKIXParameters(this.trustStore);
            parameters.setRevocationEnabled(false);
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems setting up certificate validation", e);
        }
        try {
            cpv.validate(cp, parameters);
        }
        catch (CertPathValidatorException cpve) {
            log.debug((Object)"Certificate is invalid:", (Throwable)cpve);
            throw new FailedAuthenticationException();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException("Problems setting up certificate validation", e);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

