/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse;

import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.jboss.ws.wsse.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsuIdResolver
extends ResourceResolverSpi {
    Document doc;
    Element header;

    public WsuIdResolver(Document doc) {
        this.doc = doc;
    }

    public WsuIdResolver(Document doc, Element header) {
        this.doc = doc;
        this.header = header;
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        if (uri == null) {
            return false;
        }
        String nodeValue = uri.getNodeValue();
        return nodeValue != null && nodeValue.startsWith("#");
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String id = uri.getValue().substring(1);
        Element element = this.doc.getDocumentElement();
        if ((element = Util.findElementByWsuId(element, id)) == null && this.header != null) {
            element = Util.findElementByWsuId(this.header, id);
        }
        if (element == null) {
            throw new ResourceResolverException(id, uri, BaseURI);
        }
        XMLSignatureInput input = new XMLSignatureInput((Node)element);
        input.setMIMEType("text/xml");
        input.setSourceURI(String.valueOf(BaseURI) + uri);
        return input;
    }
}

