/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse.element;

import java.security.PublicKey;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.jboss.ws.wsse.KeyResolver;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.element.SecurityProcess;
import org.w3c.dom.Element;

public class Signature
implements SecurityProcess {
    private XMLSignature signature;
    private PublicKey publicKey;
    private Element cachedElement;

    public Signature(XMLSignature signature) {
        this.signature = signature;
    }

    public Signature(Element element, KeyResolver resolver) throws WSSecurityException {
        try {
            this.signature = new XMLSignature(element, null);
            this.publicKey = resolver.resolvePublicKey(this.signature.getKeyInfo());
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Error decoding xml signature: " + e.getMessage(), e);
        }
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    public void setSignature(XMLSignature signature) {
        this.signature = signature;
    }

    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        this.cachedElement = this.signature.getElement();
        return this.cachedElement;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

