/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.el.ognl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.Ognl;
import ognl.OgnlException;
import org.codehaus.marmalade.el.AbstractExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluationException;

public class PathSafeOgnlExpressionEvaluator
extends AbstractExpressionEvaluator {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\{((#|@)[^ ]+)\\}");

    public Object doEval(String expression, Map context, Class expectedType) throws ExpressionEvaluationException {
        try {
            Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
            boolean expressionMatches = matcher.matches();
            String expr = null;
            expr = expressionMatches ? matcher.group(1) : expression;
            Object result = Ognl.getValue((String)expr, (Map)context, (Object)null);
            return result;
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException(expression, (Throwable)e);
        }
    }

    public Object assign(Object target, String property, Object value) throws ExpressionEvaluationException {
        try {
            Ognl.setValue((String)property, (Object)target, (Object)value);
            return target;
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException(property, (Throwable)e);
        }
    }

    protected Pattern getExpressionPattern() {
        return EXPRESSION_PATTERN;
    }
}

