/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtils {
    private Manifest manifest;
    private Map manifestEntries;
    private Attributes mainAttributes;
    private Attributes sectionAttributes;

    public void extractManifestFromJar(File theJarFile) throws IOException {
        JarFile jarfile = new JarFile(theJarFile);
        this.manifest = jarfile.getManifest();
        this.extractManifestEntries();
    }

    public void extractManifestFromFile(File manifestFile) throws IOException {
        FileInputStream fis = new FileInputStream(manifestFile);
        this.manifest = new Manifest(fis);
        this.extractManifestEntries();
    }

    public void setManifest(Manifest mf) {
        this.manifest = mf;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Map getManifestEntries() {
        return this.manifestEntries;
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    public boolean containsSection(String key) {
        return this.manifestEntries.containsKey(key);
    }

    public String getMainAttribute(String key) {
        return this.mainAttributes.getValue(key);
    }

    public boolean containsMainAttribute(String key) {
        boolean contains = false;
        if (this.getMainAttribute(key) != null) {
            contains = true;
        }
        return contains;
    }

    public String getSectionAttribute(String key) {
        return this.sectionAttributes.getValue(key);
    }

    public boolean containsSectionAttribute(String key) {
        boolean contains = false;
        if (this.getSectionAttribute(key) != null) {
            contains = true;
        }
        return contains;
    }

    private void extractManifestEntries() {
        this.manifestEntries = this.manifest.getEntries();
        this.mainAttributes = this.manifest.getMainAttributes();
        Iterator it = this.manifestEntries.keySet().iterator();
        while (it.hasNext()) {
            String entryName = (String)it.next();
            this.sectionAttributes = (Attributes)this.manifestEntries.get(entryName);
        }
    }
}

