/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;

class ServerMetrics {
    private static final Counter.Builder serverStartedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("started_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Total number of RPCs started on the server.");
    private static final Counter.Builder serverHandledBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("handled_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method", "code"})).help("Total number of RPCs completed on the server, regardless of success or failure.");
    private static final Histogram.Builder serverHandledLatencySecondsBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("grpc")).subsystem("server")).name("handled_latency_seconds")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Histogram of response latency (seconds) of gRPC that had been application-level handled by the server.");
    private static final Counter.Builder serverStreamMessagesReceivedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("msg_received_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Total number of stream messages received from the client.");
    private static final Counter.Builder serverStreamMessagesSentBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("server")).name("msg_sent_total")).labelNames(new String[]{"grpc_type", "grpc_service", "grpc_method"})).help("Total number of stream messages sent by the server.");
    private final Counter serverStarted;
    private final Counter serverHandled;
    private final Counter serverStreamMessagesReceived;
    private final Counter serverStreamMessagesSent;
    private final Optional<Histogram> serverHandledLatencySeconds;
    private final GrpcMethod method;

    private ServerMetrics(GrpcMethod grpcMethod, Counter counter, Counter counter2, Counter counter3, Counter counter4, Optional<Histogram> optional) {
        this.method = grpcMethod;
        this.serverStarted = counter;
        this.serverHandled = counter2;
        this.serverStreamMessagesReceived = counter3;
        this.serverStreamMessagesSent = counter4;
        this.serverHandledLatencySeconds = optional;
    }

    public void recordCallStarted() {
        ((Counter.Child)this.addLabels((SimpleCollector)this.serverStarted, new String[0])).inc();
    }

    public void recordServerHandled(Status.Code code) {
        ((Counter.Child)this.addLabels((SimpleCollector)this.serverHandled, code.toString())).inc();
    }

    public void recordStreamMessageSent() {
        ((Counter.Child)this.addLabels((SimpleCollector)this.serverStreamMessagesSent, new String[0])).inc();
    }

    public void recordStreamMessageReceived() {
        ((Counter.Child)this.addLabels((SimpleCollector)this.serverStreamMessagesReceived, new String[0])).inc();
    }

    public void recordLatency(double d) {
        if (!this.serverHandledLatencySeconds.isPresent()) {
            return;
        }
        ((Histogram.Child)this.addLabels((SimpleCollector)this.serverHandledLatencySeconds.get(), new String[0])).observe(d);
    }

    private <T> T addLabels(SimpleCollector<T> simpleCollector, String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, this.method.type(), this.method.serviceName(), this.method.methodName());
        Collections.addAll(arrayList, stringArray);
        return (T)simpleCollector.labels(arrayList.toArray(new String[0]));
    }

    static class Factory {
        private final Counter serverStarted;
        private final Counter serverHandled;
        private final Counter serverStreamMessagesReceived;
        private final Counter serverStreamMessagesSent;
        private final Optional<Histogram> serverHandledLatencySeconds;

        Factory(Configuration configuration) {
            CollectorRegistry collectorRegistry = configuration.getCollectorRegistry();
            this.serverStarted = (Counter)serverStartedBuilder.register(collectorRegistry);
            this.serverHandled = (Counter)serverHandledBuilder.register(collectorRegistry);
            this.serverStreamMessagesReceived = (Counter)serverStreamMessagesReceivedBuilder.register(collectorRegistry);
            this.serverStreamMessagesSent = (Counter)serverStreamMessagesSentBuilder.register(collectorRegistry);
            this.serverHandledLatencySeconds = configuration.isIncludeLatencyHistograms() ? Optional.of((Histogram)serverHandledLatencySecondsBuilder.buckets(configuration.getLatencyBuckets()).register(collectorRegistry)) : Optional.empty();
        }

        <R, S> ServerMetrics createMetricsForMethod(MethodDescriptor<R, S> methodDescriptor) {
            return new ServerMetrics(GrpcMethod.of(methodDescriptor), this.serverStarted, this.serverHandled, this.serverStreamMessagesReceived, this.serverStreamMessagesSent, this.serverHandledLatencySeconds);
        }
    }
}

