package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class IstioResourceListBuilder extends IstioResourceListFluentImpl<IstioResourceListBuilder> implements VisitableBuilder<IstioResourceList,IstioResourceListBuilder>{

    IstioResourceListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IstioResourceListBuilder(){
            this(true);
    }
    public IstioResourceListBuilder(Boolean validationEnabled){
            this(new IstioResourceList(), validationEnabled);
    }
    public IstioResourceListBuilder(IstioResourceListFluent<?> fluent){
            this(fluent, true);
    }
    public IstioResourceListBuilder(IstioResourceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IstioResourceList(), validationEnabled);
    }
    public IstioResourceListBuilder(IstioResourceListFluent<?> fluent,IstioResourceList instance){
            this(fluent, instance, true);
    }
    public IstioResourceListBuilder(IstioResourceListFluent<?> fluent,IstioResourceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public IstioResourceListBuilder(IstioResourceList instance){
            this(instance,true);
    }
    public IstioResourceListBuilder(IstioResourceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public IstioResourceListBuilder(Validator validator){
            this(new IstioResourceList(), true);
    }
    public IstioResourceListBuilder(IstioResourceListFluent<?> fluent,IstioResourceList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public IstioResourceListBuilder(IstioResourceList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public IstioResourceList build(){
            IstioResourceList buildable = new IstioResourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IstioResourceListBuilder that = (IstioResourceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
