package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class MutualTlsFluentImpl<A extends MutualTlsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MutualTlsFluent<A>{

    private Boolean allowTls;
    private Mode mode;

    public MutualTlsFluentImpl(){
    }
    public MutualTlsFluentImpl(MutualTls instance){
            this.withAllowTls(instance.getAllowTls()); 
            this.withMode(instance.getMode()); 
    }

    public Boolean isAllowTls(){
            return this.allowTls;
    }

    public A withAllowTls(Boolean allowTls){
            this.allowTls=allowTls; return (A) this;
    }

    public Boolean hasAllowTls(){
            return this.allowTls != null;
    }

    public A withNewAllowTls(String arg1){
            return (A)withAllowTls(new Boolean(arg1));
    }

    public A withNewAllowTls(boolean arg1){
            return (A)withAllowTls(new Boolean(arg1));
    }

    public Mode getMode(){
            return this.mode;
    }

    public A withMode(Mode mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MutualTlsFluentImpl that = (MutualTlsFluentImpl) o;
            if (allowTls != null ? !allowTls.equals(that.allowTls) :that.allowTls != null) return false;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            return true;
    }




}
