package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AttributesBuilder extends AttributesFluentImpl<AttributesBuilder> implements VisitableBuilder<Attributes,AttributesBuilder>{

    AttributesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AttributesBuilder(){
            this(true);
    }
    public AttributesBuilder(Boolean validationEnabled){
            this(new Attributes(), validationEnabled);
    }
    public AttributesBuilder(AttributesFluent<?> fluent){
            this(fluent, true);
    }
    public AttributesBuilder(AttributesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Attributes(), validationEnabled);
    }
    public AttributesBuilder(AttributesFluent<?> fluent,Attributes instance){
            this(fluent, instance, true);
    }
    public AttributesBuilder(AttributesFluent<?> fluent,Attributes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributes(instance.getAttributes()); 
            this.validationEnabled = validationEnabled; 
    }
    public AttributesBuilder(Attributes instance){
            this(instance,true);
    }
    public AttributesBuilder(Attributes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributes(instance.getAttributes()); 
            this.validationEnabled = validationEnabled; 
    }
    public AttributesBuilder(Validator validator){
            this(new Attributes(), true);
    }
    public AttributesBuilder(AttributesFluent<?> fluent,Attributes instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAttributes(instance.getAttributes()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AttributesBuilder(Attributes instance,Validator validator){
            this.fluent = this; 
            this.withAttributes(instance.getAttributes()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Attributes build(){
            Attributes buildable = new Attributes(fluent.getAttributes());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AttributesBuilder that = (AttributesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
