
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributes",
    "deduplicationId",
    "globalWordCount",
    "quotas"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class CheckRequest implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("attributes")
    @JsonPropertyDescription("")
    @Valid
    private CompressedAttributes attributes;
    /**
     * 
     * 
     */
    @JsonProperty("deduplicationId")
    @JsonPropertyDescription("")
    private java.lang.String deduplicationId;
    /**
     * 
     * 
     */
    @JsonProperty("globalWordCount")
    @JsonPropertyDescription("")
    private Integer globalWordCount;
    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, QuotaParams> quotas;
    private final static long serialVersionUID = 3192530109756331481L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CheckRequest() {
    }

    /**
     * 
     * @param globalWordCount
     * @param quotas
     * @param deduplicationId
     * @param attributes
     */
    public CheckRequest(CompressedAttributes attributes, java.lang.String deduplicationId, Integer globalWordCount, Map<String, QuotaParams> quotas) {
        super();
        this.attributes = attributes;
        this.deduplicationId = deduplicationId;
        this.globalWordCount = globalWordCount;
        this.quotas = quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributes")
    public CompressedAttributes getAttributes() {
        return attributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attributes")
    public void setAttributes(CompressedAttributes attributes) {
        this.attributes = attributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("deduplicationId")
    public java.lang.String getDeduplicationId() {
        return deduplicationId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("deduplicationId")
    public void setDeduplicationId(java.lang.String deduplicationId) {
        this.deduplicationId = deduplicationId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("globalWordCount")
    public Integer getGlobalWordCount() {
        return globalWordCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("globalWordCount")
    public void setGlobalWordCount(Integer globalWordCount) {
        this.globalWordCount = globalWordCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public Map<String, QuotaParams> getQuotas() {
        return quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public void setQuotas(Map<String, QuotaParams> quotas) {
        this.quotas = quotas;
    }

}
