
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bools",
    "bytes",
    "doubles",
    "durations",
    "int64s",
    "stringMaps",
    "strings",
    "timestamps",
    "words"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class CompressedAttributes implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("bools")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Boolean> bools;
    /**
     * 
     * 
     */
    @JsonProperty("bytes")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> bytes;
    /**
     * 
     * 
     */
    @JsonProperty("doubles")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Double> doubles;
    /**
     * 
     * 
     */
    @JsonProperty("durations")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Long> durations;
    /**
     * 
     * 
     */
    @JsonProperty("int64s")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Long> int64s;
    /**
     * 
     * 
     */
    @JsonProperty("stringMaps")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, StringMap> stringMaps;
    /**
     * 
     * 
     */
    @JsonProperty("strings")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Integer> strings;
    /**
     * 
     * 
     */
    @JsonProperty("timestamps")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> timestamps;
    /**
     * 
     * 
     */
    @JsonProperty("words")
    @JsonPropertyDescription("")
    @Valid
    private List<java.lang.String> words = new ArrayList<java.lang.String>();
    private final static long serialVersionUID = -1169561396386402251L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CompressedAttributes() {
    }

    /**
     * 
     * @param bools
     * @param stringMaps
     * @param strings
     * @param doubles
     * @param bytes
     * @param int64s
     * @param timestamps
     * @param words
     * @param durations
     */
    public CompressedAttributes(Map<String, Boolean> bools, Map<String, String> bytes, Map<String, Double> doubles, Map<String, Long> durations, Map<String, Long> int64s, Map<String, StringMap> stringMaps, Map<String, Integer> strings, Map<String, String> timestamps, List<java.lang.String> words) {
        super();
        this.bools = bools;
        this.bytes = bytes;
        this.doubles = doubles;
        this.durations = durations;
        this.int64s = int64s;
        this.stringMaps = stringMaps;
        this.strings = strings;
        this.timestamps = timestamps;
        this.words = words;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bools")
    public Map<String, Boolean> getBools() {
        return bools;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bools")
    public void setBools(Map<String, Boolean> bools) {
        this.bools = bools;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bytes")
    public Map<String, String> getBytes() {
        return bytes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bytes")
    public void setBytes(Map<String, String> bytes) {
        this.bytes = bytes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("doubles")
    public Map<String, Double> getDoubles() {
        return doubles;
    }

    /**
     * 
     * 
     */
    @JsonProperty("doubles")
    public void setDoubles(Map<String, Double> doubles) {
        this.doubles = doubles;
    }

    /**
     * 
     * 
     */
    @JsonProperty("durations")
    public Map<String, Long> getDurations() {
        return durations;
    }

    /**
     * 
     * 
     */
    @JsonProperty("durations")
    public void setDurations(Map<String, Long> durations) {
        this.durations = durations;
    }

    /**
     * 
     * 
     */
    @JsonProperty("int64s")
    public Map<String, Long> getInt64s() {
        return int64s;
    }

    /**
     * 
     * 
     */
    @JsonProperty("int64s")
    public void setInt64s(Map<String, Long> int64s) {
        this.int64s = int64s;
    }

    /**
     * 
     * 
     */
    @JsonProperty("stringMaps")
    public Map<String, StringMap> getStringMaps() {
        return stringMaps;
    }

    /**
     * 
     * 
     */
    @JsonProperty("stringMaps")
    public void setStringMaps(Map<String, StringMap> stringMaps) {
        this.stringMaps = stringMaps;
    }

    /**
     * 
     * 
     */
    @JsonProperty("strings")
    public Map<String, Integer> getStrings() {
        return strings;
    }

    /**
     * 
     * 
     */
    @JsonProperty("strings")
    public void setStrings(Map<String, Integer> strings) {
        this.strings = strings;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamps")
    public Map<String, String> getTimestamps() {
        return timestamps;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamps")
    public void setTimestamps(Map<String, String> timestamps) {
        this.timestamps = timestamps;
    }

    /**
     * 
     * 
     */
    @JsonProperty("words")
    public List<java.lang.String> getWords() {
        return words;
    }

    /**
     * 
     * 
     */
    @JsonProperty("words")
    public void setWords(List<java.lang.String> words) {
        this.words = words;
    }

}
