package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import me.snowdrop.istio.api.Status;
import java.lang.Integer;
import javax.validation.Valid;
import me.snowdrop.istio.api.StatusFluentImpl;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.StatusBuilder;

public class PreconditionResultFluentImpl<A extends PreconditionResultFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PreconditionResultFluent<A>{

    private ReferencedAttributesBuilder referencedAttributes;
    private RouteDirectiveBuilder routeDirective;
    private StatusBuilder status;
    private Long validDuration;
    private Integer validUseCount;

    public PreconditionResultFluentImpl(){
    }
    public PreconditionResultFluentImpl(PreconditionResult instance){
            this.withReferencedAttributes(instance.getReferencedAttributes()); 
            this.withRouteDirective(instance.getRouteDirective()); 
            this.withStatus(instance.getStatus()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.withValidUseCount(instance.getValidUseCount()); 
    }

    
/**
 * This method has been deprecated, please use method buildReferencedAttributes instead.
 * @return The buildable object.
 */
@Deprecated public ReferencedAttributes getReferencedAttributes(){
            return this.referencedAttributes!=null?this.referencedAttributes.build():null;
    }

    public ReferencedAttributes buildReferencedAttributes(){
            return this.referencedAttributes!=null?this.referencedAttributes.build():null;
    }

    public A withReferencedAttributes(ReferencedAttributes referencedAttributes){
            _visitables.remove(this.referencedAttributes);
            if (referencedAttributes!=null){ this.referencedAttributes= new ReferencedAttributesBuilder(referencedAttributes); _visitables.add(this.referencedAttributes);} return (A) this;
    }

    public Boolean hasReferencedAttributes(){
            return this.referencedAttributes != null;
    }

    public PreconditionResultFluent.ReferencedAttributesNested<A> withNewReferencedAttributes(){
            return new ReferencedAttributesNestedImpl();
    }

    public PreconditionResultFluent.ReferencedAttributesNested<A> withNewReferencedAttributesLike(ReferencedAttributes item){
            return new ReferencedAttributesNestedImpl(item);
    }

    public PreconditionResultFluent.ReferencedAttributesNested<A> editReferencedAttributes(){
            return withNewReferencedAttributesLike(getReferencedAttributes());
    }

    public PreconditionResultFluent.ReferencedAttributesNested<A> editOrNewReferencedAttributes(){
            return withNewReferencedAttributesLike(getReferencedAttributes() != null ? getReferencedAttributes(): new ReferencedAttributesBuilder().build());
    }

    public PreconditionResultFluent.ReferencedAttributesNested<A> editOrNewReferencedAttributesLike(ReferencedAttributes item){
            return withNewReferencedAttributesLike(getReferencedAttributes() != null ? getReferencedAttributes(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRouteDirective instead.
 * @return The buildable object.
 */
@Deprecated public RouteDirective getRouteDirective(){
            return this.routeDirective!=null?this.routeDirective.build():null;
    }

    public RouteDirective buildRouteDirective(){
            return this.routeDirective!=null?this.routeDirective.build():null;
    }

    public A withRouteDirective(RouteDirective routeDirective){
            _visitables.remove(this.routeDirective);
            if (routeDirective!=null){ this.routeDirective= new RouteDirectiveBuilder(routeDirective); _visitables.add(this.routeDirective);} return (A) this;
    }

    public Boolean hasRouteDirective(){
            return this.routeDirective != null;
    }

    public PreconditionResultFluent.RouteDirectiveNested<A> withNewRouteDirective(){
            return new RouteDirectiveNestedImpl();
    }

    public PreconditionResultFluent.RouteDirectiveNested<A> withNewRouteDirectiveLike(RouteDirective item){
            return new RouteDirectiveNestedImpl(item);
    }

    public PreconditionResultFluent.RouteDirectiveNested<A> editRouteDirective(){
            return withNewRouteDirectiveLike(getRouteDirective());
    }

    public PreconditionResultFluent.RouteDirectiveNested<A> editOrNewRouteDirective(){
            return withNewRouteDirectiveLike(getRouteDirective() != null ? getRouteDirective(): new RouteDirectiveBuilder().build());
    }

    public PreconditionResultFluent.RouteDirectiveNested<A> editOrNewRouteDirectiveLike(RouteDirective item){
            return withNewRouteDirectiveLike(getRouteDirective() != null ? getRouteDirective(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.Status getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public me.snowdrop.istio.api.Status buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(me.snowdrop.istio.api.Status status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new StatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public PreconditionResultFluent.ApiStatusNested<A> withNewApiStatus(){
            return new ApiStatusNestedImpl();
    }

    public PreconditionResultFluent.ApiStatusNested<A> withNewStatusLike(me.snowdrop.istio.api.Status item){
            return new ApiStatusNestedImpl(item);
    }

    public PreconditionResultFluent.ApiStatusNested<A> editApiStatus(){
            return withNewStatusLike(getStatus());
    }

    public PreconditionResultFluent.ApiStatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new StatusBuilder().build());
    }

    public PreconditionResultFluent.ApiStatusNested<A> editOrNewStatusLike(me.snowdrop.istio.api.Status item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public Long getValidDuration(){
            return this.validDuration;
    }

    public A withValidDuration(Long validDuration){
            this.validDuration=validDuration; return (A) this;
    }

    public Boolean hasValidDuration(){
            return this.validDuration != null;
    }

    public A withNewValidDuration(String arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public A withNewValidDuration(long arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public Integer getValidUseCount(){
            return this.validUseCount;
    }

    public A withValidUseCount(Integer validUseCount){
            this.validUseCount=validUseCount; return (A) this;
    }

    public Boolean hasValidUseCount(){
            return this.validUseCount != null;
    }

    public A withNewValidUseCount(String arg1){
            return (A)withValidUseCount(new Integer(arg1));
    }

    public A withNewValidUseCount(int arg1){
            return (A)withValidUseCount(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PreconditionResultFluentImpl that = (PreconditionResultFluentImpl) o;
            if (referencedAttributes != null ? !referencedAttributes.equals(that.referencedAttributes) :that.referencedAttributes != null) return false;
            if (routeDirective != null ? !routeDirective.equals(that.routeDirective) :that.routeDirective != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (validDuration != null ? !validDuration.equals(that.validDuration) :that.validDuration != null) return false;
            if (validUseCount != null ? !validUseCount.equals(that.validUseCount) :that.validUseCount != null) return false;
            return true;
    }


    public class ReferencedAttributesNestedImpl<N> extends ReferencedAttributesFluentImpl<PreconditionResultFluent.ReferencedAttributesNested<N>> implements PreconditionResultFluent.ReferencedAttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReferencedAttributesBuilder builder;
    
            ReferencedAttributesNestedImpl(ReferencedAttributes item){
                    this.builder = new ReferencedAttributesBuilder(this, item);
            }
            ReferencedAttributesNestedImpl(){
                    this.builder = new ReferencedAttributesBuilder(this);
            }
    
    public N and(){
            return (N) PreconditionResultFluentImpl.this.withReferencedAttributes(builder.build());
    }
    public N endReferencedAttributes(){
            return and();
    }

}
    public class RouteDirectiveNestedImpl<N> extends RouteDirectiveFluentImpl<PreconditionResultFluent.RouteDirectiveNested<N>> implements PreconditionResultFluent.RouteDirectiveNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteDirectiveBuilder builder;
    
            RouteDirectiveNestedImpl(RouteDirective item){
                    this.builder = new RouteDirectiveBuilder(this, item);
            }
            RouteDirectiveNestedImpl(){
                    this.builder = new RouteDirectiveBuilder(this);
            }
    
    public N and(){
            return (N) PreconditionResultFluentImpl.this.withRouteDirective(builder.build());
    }
    public N endRouteDirective(){
            return and();
    }

}
    public class ApiStatusNestedImpl<N> extends StatusFluentImpl<PreconditionResultFluent.ApiStatusNested<N>> implements PreconditionResultFluent.ApiStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StatusBuilder builder;
    
            ApiStatusNestedImpl(me.snowdrop.istio.api.Status item){
                    this.builder = new StatusBuilder(this, item);
            }
            ApiStatusNestedImpl(){
                    this.builder = new StatusBuilder(this);
            }
    
    public N and(){
            return (N) PreconditionResultFluentImpl.this.withStatus(builder.build());
    }
    public N endApiStatus(){
            return and();
    }

}


}
