package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ReportResponseBuilder extends ReportResponseFluentImpl<ReportResponseBuilder> implements VisitableBuilder<ReportResponse,ReportResponseBuilder>{

    ReportResponseFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ReportResponseBuilder(){
            this(true);
    }
    public ReportResponseBuilder(Boolean validationEnabled){
            this(new ReportResponse(), validationEnabled);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent){
            this(fluent, true);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReportResponse(), validationEnabled);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,ReportResponse instance){
            this(fluent, instance, true);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,ReportResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public ReportResponseBuilder(ReportResponse instance){
            this(instance,true);
    }
    public ReportResponseBuilder(ReportResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }
    public ReportResponseBuilder(Validator validator){
            this(new ReportResponse(), true);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,ReportResponse instance,Validator validator){
            this.fluent = fluent; 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ReportResponseBuilder(ReportResponse instance,Validator validator){
            this.fluent = this; 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ReportResponse build(){
            ReportResponse buildable = new ReportResponse();
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportResponseBuilder that = (ReportResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
