package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RouteDirectiveBuilder extends RouteDirectiveFluentImpl<RouteDirectiveBuilder> implements VisitableBuilder<RouteDirective,RouteDirectiveBuilder>{

    RouteDirectiveFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RouteDirectiveBuilder(){
            this(true);
    }
    public RouteDirectiveBuilder(Boolean validationEnabled){
            this(new RouteDirective(), validationEnabled);
    }
    public RouteDirectiveBuilder(RouteDirectiveFluent<?> fluent){
            this(fluent, true);
    }
    public RouteDirectiveBuilder(RouteDirectiveFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteDirective(), validationEnabled);
    }
    public RouteDirectiveBuilder(RouteDirectiveFluent<?> fluent,RouteDirective instance){
            this(fluent, instance, true);
    }
    public RouteDirectiveBuilder(RouteDirectiveFluent<?> fluent,RouteDirective instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDirectResponseBody(instance.getDirectResponseBody()); 
            fluent.withDirectResponseCode(instance.getDirectResponseCode()); 
            fluent.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            fluent.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteDirectiveBuilder(RouteDirective instance){
            this(instance,true);
    }
    public RouteDirectiveBuilder(RouteDirective instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDirectResponseBody(instance.getDirectResponseBody()); 
            this.withDirectResponseCode(instance.getDirectResponseCode()); 
            this.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            this.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteDirectiveBuilder(Validator validator){
            this(new RouteDirective(), true);
    }
    public RouteDirectiveBuilder(RouteDirectiveFluent<?> fluent,RouteDirective instance,Validator validator){
            this.fluent = fluent; 
            fluent.withDirectResponseBody(instance.getDirectResponseBody()); 
            fluent.withDirectResponseCode(instance.getDirectResponseCode()); 
            fluent.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            fluent.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RouteDirectiveBuilder(RouteDirective instance,Validator validator){
            this.fluent = this; 
            this.withDirectResponseBody(instance.getDirectResponseBody()); 
            this.withDirectResponseCode(instance.getDirectResponseCode()); 
            this.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            this.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RouteDirective build(){
            RouteDirective buildable = new RouteDirective(fluent.getDirectResponseBody(),fluent.getDirectResponseCode(),fluent.getRequestHeaderOperations(),fluent.getResponseHeaderOperations());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteDirectiveBuilder that = (RouteDirectiveBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
