package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DestinationWeightFluentImpl<A extends DestinationWeightFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DestinationWeightFluent<A>{

    private DestinationBuilder destination;
    private Integer weight;

    public DestinationWeightFluentImpl(){
    }
    public DestinationWeightFluentImpl(DestinationWeight instance){
            this.withDestination(instance.getDestination()); 
            this.withWeight(instance.getWeight()); 
    }

    
/**
 * This method has been deprecated, please use method buildDestination instead.
 * @return The buildable object.
 */
@Deprecated public Destination getDestination(){
            return this.destination!=null?this.destination.build():null;
    }

    public Destination buildDestination(){
            return this.destination!=null?this.destination.build():null;
    }

    public A withDestination(Destination destination){
            _visitables.remove(this.destination);
            if (destination!=null){ this.destination= new DestinationBuilder(destination); _visitables.add(this.destination);} return (A) this;
    }

    public Boolean hasDestination(){
            return this.destination != null;
    }

    public DestinationWeightFluent.DestinationNested<A> withNewDestination(){
            return new DestinationNestedImpl();
    }

    public DestinationWeightFluent.DestinationNested<A> withNewDestinationLike(Destination item){
            return new DestinationNestedImpl(item);
    }

    public DestinationWeightFluent.DestinationNested<A> editDestination(){
            return withNewDestinationLike(getDestination());
    }

    public DestinationWeightFluent.DestinationNested<A> editOrNewDestination(){
            return withNewDestinationLike(getDestination() != null ? getDestination(): new DestinationBuilder().build());
    }

    public DestinationWeightFluent.DestinationNested<A> editOrNewDestinationLike(Destination item){
            return withNewDestinationLike(getDestination() != null ? getDestination(): item);
    }

    public Integer getWeight(){
            return this.weight;
    }

    public A withWeight(Integer weight){
            this.weight=weight; return (A) this;
    }

    public Boolean hasWeight(){
            return this.weight != null;
    }

    public A withNewWeight(String arg1){
            return (A)withWeight(new Integer(arg1));
    }

    public A withNewWeight(int arg1){
            return (A)withWeight(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationWeightFluentImpl that = (DestinationWeightFluentImpl) o;
            if (destination != null ? !destination.equals(that.destination) :that.destination != null) return false;
            if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
            return true;
    }


    public class DestinationNestedImpl<N> extends DestinationFluentImpl<DestinationWeightFluent.DestinationNested<N>> implements DestinationWeightFluent.DestinationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationBuilder builder;
    
            DestinationNestedImpl(Destination item){
                    this.builder = new DestinationBuilder(this, item);
            }
            DestinationNestedImpl(){
                    this.builder = new DestinationBuilder(this);
            }
    
    public N and(){
            return (N) DestinationWeightFluentImpl.this.withDestination(builder.build());
    }
    public N endDestination(){
            return and();
    }

}


}
