package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class EndpointFluentImpl<A extends EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointFluent<A>{

    private String address;
    private Map<String,String> labels;
    private Map<String,Integer> ports;

    public EndpointFluentImpl(){
    }
    public EndpointFluentImpl(Endpoint instance){
            this.withAddress(instance.getAddress()); 
            this.withLabels(instance.getLabels()); 
            this.withPorts(instance.getPorts()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A addToLabels(String key,String value){
            if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(this.labels == null) { return (A) this; }
            if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(this.labels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels != null;
    }

    public A addToPorts(String key,Integer value){
            if(this.ports == null && key != null && value != null) { this.ports = new LinkedHashMap<String,Integer>(); }
            if(key != null && value != null) {this.ports.put(key, value);} return (A)this;
    }

    public A addToPorts(Map<String,Integer> map){
            if(this.ports == null && map != null) { this.ports = new LinkedHashMap<String,Integer>(); }
            if(map != null) { this.ports.putAll(map);} return (A)this;
    }

    public A removeFromPorts(String key){
            if(this.ports == null) { return (A) this; }
            if(key != null && this.ports != null) {this.ports.remove(key);} return (A)this;
    }

    public A removeFromPorts(Map<String,Integer> map){
            if(this.ports == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.ports != null){this.ports.remove(key);}}} return (A)this;
    }

    public Map<String,Integer> getPorts(){
            return this.ports;
    }

    public A withPorts(Map<String,Integer> ports){
            if (ports == null) { this.ports =  null;} else {this.ports = new LinkedHashMap<String,Integer>(ports);} return (A) this;
    }

    public Boolean hasPorts(){
            return this.ports != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointFluentImpl that = (EndpointFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }




}
