package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class EnvoyFilterBuilder extends EnvoyFilterFluentImpl<EnvoyFilterBuilder> implements VisitableBuilder<EnvoyFilter,EnvoyFilterBuilder>{

    EnvoyFilterFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EnvoyFilterBuilder(){
            this(true);
    }
    public EnvoyFilterBuilder(Boolean validationEnabled){
            this(new EnvoyFilter(), validationEnabled);
    }
    public EnvoyFilterBuilder(EnvoyFilterFluent<?> fluent){
            this(fluent, true);
    }
    public EnvoyFilterBuilder(EnvoyFilterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EnvoyFilter(), validationEnabled);
    }
    public EnvoyFilterBuilder(EnvoyFilterFluent<?> fluent,EnvoyFilter instance){
            this(fluent, instance, true);
    }
    public EnvoyFilterBuilder(EnvoyFilterFluent<?> fluent,EnvoyFilter instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvoyFilterBuilder(EnvoyFilter instance){
            this(instance,true);
    }
    public EnvoyFilterBuilder(EnvoyFilter instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvoyFilterBuilder(Validator validator){
            this(new EnvoyFilter(), true);
    }
    public EnvoyFilterBuilder(EnvoyFilterFluent<?> fluent,EnvoyFilter instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public EnvoyFilterBuilder(EnvoyFilter instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public EnvoyFilter build(){
            EnvoyFilter buildable = new EnvoyFilter(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvoyFilterBuilder that = (EnvoyFilterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
