
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.networking.v1alpha3.Delay.HttpDelayType;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "fixedDelay"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class FixedDelayHttpDelayType implements Serializable, HttpDelayType
{

    /**
     * 
     * 
     */
    @JsonProperty("fixedDelay")
    @JsonPropertyDescription("")
    @Valid
    private Duration fixedDelay;
    private final static long serialVersionUID = -7807096681534737881L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FixedDelayHttpDelayType() {
    }

    /**
     * 
     * @param fixedDelay
     */
    public FixedDelayHttpDelayType(Duration fixedDelay) {
        super();
        this.fixedDelay = fixedDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fixedDelay")
    public Duration getFixedDelay() {
        return fixedDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fixedDelay")
    public void setFixedDelay(Duration fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

}
