package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class GrpcStatusErrorTypeBuilder extends GrpcStatusErrorTypeFluentImpl<GrpcStatusErrorTypeBuilder> implements VisitableBuilder<GrpcStatusErrorType,GrpcStatusErrorTypeBuilder>{

    GrpcStatusErrorTypeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GrpcStatusErrorTypeBuilder(){
            this(true);
    }
    public GrpcStatusErrorTypeBuilder(Boolean validationEnabled){
            this(new GrpcStatusErrorType(), validationEnabled);
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorTypeFluent<?> fluent){
            this(fluent, true);
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GrpcStatusErrorType(), validationEnabled);
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorTypeFluent<?> fluent,GrpcStatusErrorType instance){
            this(fluent, instance, true);
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorTypeFluent<?> fluent,GrpcStatusErrorType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGrpcStatus(instance.getGrpcStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorType instance){
            this(instance,true);
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGrpcStatus(instance.getGrpcStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public GrpcStatusErrorTypeBuilder(Validator validator){
            this(new GrpcStatusErrorType(), true);
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorTypeFluent<?> fluent,GrpcStatusErrorType instance,Validator validator){
            this.fluent = fluent; 
            fluent.withGrpcStatus(instance.getGrpcStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public GrpcStatusErrorTypeBuilder(GrpcStatusErrorType instance,Validator validator){
            this.fluent = this; 
            this.withGrpcStatus(instance.getGrpcStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public GrpcStatusErrorType build(){
            GrpcStatusErrorType buildable = new GrpcStatusErrorType(fluent.getGrpcStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GrpcStatusErrorTypeBuilder that = (GrpcStatusErrorTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
