package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HTTPRetryBuilder extends HTTPRetryFluentImpl<HTTPRetryBuilder> implements VisitableBuilder<HTTPRetry,HTTPRetryBuilder>{

    HTTPRetryFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPRetryBuilder(){
            this(true);
    }
    public HTTPRetryBuilder(Boolean validationEnabled){
            this(new HTTPRetry(), validationEnabled);
    }
    public HTTPRetryBuilder(HTTPRetryFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPRetry(), validationEnabled);
    }
    public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,HTTPRetry instance){
            this(fluent, instance, true);
    }
    public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,HTTPRetry instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttempts(instance.getAttempts()); 
            fluent.withPerTryTimeout(instance.getPerTryTimeout()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRetryBuilder(HTTPRetry instance){
            this(instance,true);
    }
    public HTTPRetryBuilder(HTTPRetry instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttempts(instance.getAttempts()); 
            this.withPerTryTimeout(instance.getPerTryTimeout()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRetryBuilder(Validator validator){
            this(new HTTPRetry(), true);
    }
    public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,HTTPRetry instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAttempts(instance.getAttempts()); 
            fluent.withPerTryTimeout(instance.getPerTryTimeout()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HTTPRetryBuilder(HTTPRetry instance,Validator validator){
            this.fluent = this; 
            this.withAttempts(instance.getAttempts()); 
            this.withPerTryTimeout(instance.getPerTryTimeout()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HTTPRetry build(){
            HTTPRetry buildable = new HTTPRetry(fluent.getAttempts(),fluent.getPerTryTimeout());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPRetryBuilder that = (HTTPRetryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
