package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PortBuilder extends PortFluentImpl<PortBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1alpha3.Port,PortBuilder>{

    PortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PortBuilder(){
            this(true);
    }
    public PortBuilder(Boolean validationEnabled){
            this(new Port(), validationEnabled);
    }
    public PortBuilder(PortFluent<?> fluent){
            this(fluent, true);
    }
    public PortBuilder(PortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Port(), validationEnabled);
    }
    public PortBuilder(PortFluent<?> fluent,me.snowdrop.istio.api.networking.v1alpha3.Port instance){
            this(fluent, instance, true);
    }
    public PortBuilder(PortFluent<?> fluent,me.snowdrop.istio.api.networking.v1alpha3.Port instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withNumber(instance.getNumber()); 
            fluent.withProtocol(instance.getProtocol()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1alpha3.Port instance){
            this(instance,true);
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1alpha3.Port instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withNumber(instance.getNumber()); 
            this.withProtocol(instance.getProtocol()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortBuilder(Validator validator){
            this(new Port(), true);
    }
    public PortBuilder(PortFluent<?> fluent,me.snowdrop.istio.api.networking.v1alpha3.Port instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withNumber(instance.getNumber()); 
            fluent.withProtocol(instance.getProtocol()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1alpha3.Port instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withNumber(instance.getNumber()); 
            this.withProtocol(instance.getProtocol()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Port build(){
            Port buildable = new Port(fluent.getName(),fluent.getNumber(),fluent.getProtocol());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortBuilder that = (PortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
