package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PortTrafficPolicyBuilder extends PortTrafficPolicyFluentImpl<PortTrafficPolicyBuilder> implements VisitableBuilder<PortTrafficPolicy,PortTrafficPolicyBuilder>{

    PortTrafficPolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PortTrafficPolicyBuilder(){
            this(true);
    }
    public PortTrafficPolicyBuilder(Boolean validationEnabled){
            this(new PortTrafficPolicy(), validationEnabled);
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PortTrafficPolicy(), validationEnabled);
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicyFluent<?> fluent,PortTrafficPolicy instance){
            this(fluent, instance, true);
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicyFluent<?> fluent,PortTrafficPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectionPool(instance.getConnectionPool()); 
            fluent.withLoadBalancer(instance.getLoadBalancer()); 
            fluent.withOutlierDetection(instance.getOutlierDetection()); 
            fluent.withPort(instance.getPort()); 
            fluent.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicy instance){
            this(instance,true);
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortTrafficPolicyBuilder(Validator validator){
            this(new PortTrafficPolicy(), true);
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicyFluent<?> fluent,PortTrafficPolicy instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConnectionPool(instance.getConnectionPool()); 
            fluent.withLoadBalancer(instance.getLoadBalancer()); 
            fluent.withOutlierDetection(instance.getOutlierDetection()); 
            fluent.withPort(instance.getPort()); 
            fluent.withTls(instance.getTls()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PortTrafficPolicyBuilder(PortTrafficPolicy instance,Validator validator){
            this.fluent = this; 
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public PortTrafficPolicy build(){
            PortTrafficPolicy buildable = new PortTrafficPolicy(fluent.getConnectionPool(),fluent.getLoadBalancer(),fluent.getOutlierDetection(),fluent.getPort(),fluent.getTls());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortTrafficPolicyBuilder that = (PortTrafficPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
