package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class ServiceEntrySpecFluentImpl<A extends ServiceEntrySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceEntrySpecFluent<A>{

    private List<String> addresses;
    private List<EndpointBuilder> endpoints;
    private List<String> hosts;
    private ServiceEntryLocation location;
    private List<PortBuilder> ports;
    private ServiceEntryResolution resolution;

    public ServiceEntrySpecFluentImpl(){
    }
    public ServiceEntrySpecFluentImpl(ServiceEntrySpec instance){
            this.withAddresses(instance.getAddresses()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withHosts(instance.getHosts()); 
            this.withLocation(instance.getLocation()); 
            this.withPorts(instance.getPorts()); 
            this.withResolution(instance.getResolution()); 
    }

    public A addToAddresses(int index,String item){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            this.addresses.add(index, item);
            return (A)this;
    }

    public A setToAddresses(int index,String item){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            this.addresses.set(index, item); return (A)this;
    }

    public A addToAddresses(String... items){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A addAllToAddresses(Collection<String> items){
            if (this.addresses == null) {this.addresses = new ArrayList<String>();}
            for (String item : items) {this.addresses.add(item);} return (A)this;
    }

    public A removeFromAddresses(String... items){
            for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<String> items){
            for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
    }

    public List<String> getAddresses(){
            return this.addresses;
    }

    public String getAddress(int index){
            return this.addresses.get(index);
    }

    public String getFirstAddress(){
            return this.addresses.get(0);
    }

    public String getLastAddress(){
            return this.addresses.get(addresses.size() - 1);
    }

    public String getMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: addresses) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAddresses(List<String> addresses){
            if (this.addresses != null) { _visitables.removeAll(this.addresses);}
            if (addresses != null) {this.addresses = new ArrayList<String>(); for (String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(String... addresses){
            if (this.addresses != null) {this.addresses.clear();}
            if (addresses != null) {for (String item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses(){
            return addresses != null && !addresses.isEmpty();
    }

    public A addToEndpoints(int index,Endpoint item){
            if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
            EndpointBuilder builder = new EndpointBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
    }

    public A setToEndpoints(int index,Endpoint item){
            if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
            EndpointBuilder builder = new EndpointBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
             return (A)this;
    }

    public A addToEndpoints(Endpoint... items){
            if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
            for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A addAllToEndpoints(Collection<Endpoint> items){
            if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
            for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A removeFromEndpoints(Endpoint... items){
            for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromEndpoints(Collection<Endpoint> items){
            for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<Endpoint> getEndpoints(){
            return build(endpoints);
    }

    public List<Endpoint> buildEndpoints(){
            return build(endpoints);
    }

    public Endpoint buildEndpoint(int index){
            return this.endpoints.get(index).build();
    }

    public Endpoint buildFirstEndpoint(){
            return this.endpoints.get(0).build();
    }

    public Endpoint buildLastEndpoint(){
            return this.endpoints.get(endpoints.size() - 1).build();
    }

    public Endpoint buildMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<EndpointBuilder> predicate){
            for (EndpointBuilder item: endpoints) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withEndpoints(List<Endpoint> endpoints){
            if (this.endpoints != null) { _visitables.removeAll(this.endpoints);}
            if (endpoints != null) {this.endpoints = new ArrayList<EndpointBuilder>(); for (Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
    }

    public A withEndpoints(Endpoint... endpoints){
            if (this.endpoints != null) {this.endpoints.clear();}
            if (endpoints != null) {for (Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
    }

    public Boolean hasEndpoints(){
            return endpoints != null && !endpoints.isEmpty();
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint(){
            return new EndpointsNestedImpl();
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item){
            return new EndpointsNestedImpl(-1, item);
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item){
            return new EndpointsNestedImpl(index, item);
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(int index){
            if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint(){
            if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
            return setNewEndpointLike(0, buildEndpoint(0));
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint(){
            int index = endpoints.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<EndpointBuilder> predicate){
            int index = -1;
            for (int i=0;i<endpoints.size();i++) { 
            if (predicate.apply(endpoints.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public A addToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.add(index, item);
            return (A)this;
    }

    public A setToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.set(index, item); return (A)this;
    }

    public A addToHosts(String... items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A addAllToHosts(Collection<String> items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public String getHost(int index){
            return this.hosts.get(index);
    }

    public String getFirstHost(){
            return this.hosts.get(0);
    }

    public String getLastHost(){
            return this.hosts.get(hosts.size() - 1);
    }

    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withHosts(List<String> hosts){
            if (this.hosts != null) { _visitables.removeAll(this.hosts);}
            if (hosts != null) {this.hosts = new ArrayList<String>(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
    }

    public A withHosts(String... hosts){
            if (this.hosts != null) {this.hosts.clear();}
            if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public Boolean hasHosts(){
            return hosts != null && !hosts.isEmpty();
    }

    public ServiceEntryLocation getLocation(){
            return this.location;
    }

    public A withLocation(ServiceEntryLocation location){
            this.location=location; return (A) this;
    }

    public Boolean hasLocation(){
            return this.location != null;
    }

    public A addToPorts(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            me.snowdrop.istio.api.networking.v1alpha3.PortBuilder builder = new me.snowdrop.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            me.snowdrop.istio.api.networking.v1alpha3.PortBuilder builder = new me.snowdrop.istio.api.networking.v1alpha3.PortBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(me.snowdrop.istio.api.networking.v1alpha3.Port... items){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            for (me.snowdrop.istio.api.networking.v1alpha3.Port item : items) {me.snowdrop.istio.api.networking.v1alpha3.PortBuilder builder = new me.snowdrop.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<me.snowdrop.istio.api.networking.v1alpha3.Port> items){
            if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
            for (me.snowdrop.istio.api.networking.v1alpha3.Port item : items) {me.snowdrop.istio.api.networking.v1alpha3.PortBuilder builder = new me.snowdrop.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(me.snowdrop.istio.api.networking.v1alpha3.Port... items){
            for (me.snowdrop.istio.api.networking.v1alpha3.Port item : items) {me.snowdrop.istio.api.networking.v1alpha3.PortBuilder builder = new me.snowdrop.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<me.snowdrop.istio.api.networking.v1alpha3.Port> items){
            for (me.snowdrop.istio.api.networking.v1alpha3.Port item : items) {me.snowdrop.istio.api.networking.v1alpha3.PortBuilder builder = new me.snowdrop.istio.api.networking.v1alpha3.PortBuilder(item);_visitables.remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1alpha3.Port> getPorts(){
            return build(ports);
    }

    public List<me.snowdrop.istio.api.networking.v1alpha3.Port> buildPorts(){
            return build(ports);
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Port buildPort(int index){
            return this.ports.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Port buildFirstPort(){
            return this.ports.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Port buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Port buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate){
            for (PortBuilder item: ports) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withPorts(List<me.snowdrop.istio.api.networking.v1alpha3.Port> ports){
            if (this.ports != null) { _visitables.removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<PortBuilder>(); for (me.snowdrop.istio.api.networking.v1alpha3.Port item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(me.snowdrop.istio.api.networking.v1alpha3.Port... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (me.snowdrop.istio.api.networking.v1alpha3.Port item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public A addNewPort(String name,Integer number,String protocol){
            return (A)addToPorts(new Port(name, number, protocol));
    }

    public ServiceEntrySpecFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(me.snowdrop.istio.api.networking.v1alpha3.Port item){
            return new PortsNestedImpl(-1, item);
    }

    public ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item){
            return new PortsNestedImpl(index, item);
    }

    public ServiceEntrySpecFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public ServiceEntrySpecFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public ServiceEntrySpecFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public ServiceEntryResolution getResolution(){
            return this.resolution;
    }

    public A withResolution(ServiceEntryResolution resolution){
            this.resolution=resolution; return (A) this;
    }

    public Boolean hasResolution(){
            return this.resolution != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceEntrySpecFluentImpl that = (ServiceEntrySpecFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (location != null ? !location.equals(that.location) :that.location != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (resolution != null ? !resolution.equals(that.resolution) :that.resolution != null) return false;
            return true;
    }


    public class EndpointsNestedImpl<N> extends EndpointFluentImpl<ServiceEntrySpecFluent.EndpointsNested<N>> implements ServiceEntrySpecFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EndpointBuilder builder;
        private final int index;
    
            EndpointsNestedImpl(int index,Endpoint item){
                    this.index = index;
                    this.builder = new EndpointBuilder(this, item);
            }
            EndpointsNestedImpl(){
                    this.index = -1;
                    this.builder = new EndpointBuilder(this);
            }
    
    public N and(){
            return (N) ServiceEntrySpecFluentImpl.this.setToEndpoints(index, builder.build());
    }
    public N endEndpoint(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends PortFluentImpl<ServiceEntrySpecFluent.PortsNested<N>> implements ServiceEntrySpecFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item){
                    this.index = index;
                    this.builder = new PortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new PortBuilder(this);
            }
    
    public N and(){
            return (N) ServiceEntrySpecFluentImpl.this.setToPorts(index, builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
