package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TCPSettingsBuilder extends TCPSettingsFluentImpl<TCPSettingsBuilder> implements VisitableBuilder<TCPSettings,TCPSettingsBuilder>{

    TCPSettingsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TCPSettingsBuilder(){
            this(true);
    }
    public TCPSettingsBuilder(Boolean validationEnabled){
            this(new TCPSettings(), validationEnabled);
    }
    public TCPSettingsBuilder(TCPSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public TCPSettingsBuilder(TCPSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TCPSettings(), validationEnabled);
    }
    public TCPSettingsBuilder(TCPSettingsFluent<?> fluent,TCPSettings instance){
            this(fluent, instance, true);
    }
    public TCPSettingsBuilder(TCPSettingsFluent<?> fluent,TCPSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withMaxConnections(instance.getMaxConnections()); 
            this.validationEnabled = validationEnabled; 
    }
    public TCPSettingsBuilder(TCPSettings instance){
            this(instance,true);
    }
    public TCPSettingsBuilder(TCPSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withMaxConnections(instance.getMaxConnections()); 
            this.validationEnabled = validationEnabled; 
    }
    public TCPSettingsBuilder(Validator validator){
            this(new TCPSettings(), true);
    }
    public TCPSettingsBuilder(TCPSettingsFluent<?> fluent,TCPSettings instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withMaxConnections(instance.getMaxConnections()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TCPSettingsBuilder(TCPSettings instance,Validator validator){
            this.fluent = this; 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withMaxConnections(instance.getMaxConnections()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TCPSettings build(){
            TCPSettings buildable = new TCPSettings(fluent.getConnectTimeout(),fluent.getMaxConnections());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPSettingsBuilder that = (TCPSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
