package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface RuleFluent<A extends RuleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public RuleFluent.MetadataNested<A> withNewMetadata();
    public RuleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RuleFluent.MetadataNested<A> editMetadata();
    public RuleFluent.MetadataNested<A> editOrNewMetadata();
    public RuleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public RuleSpec getSpec();
    public RuleSpec buildSpec();
    public A withSpec(RuleSpec spec);
    public Boolean hasSpec();
    public RuleFluent.SpecNested<A> withNewSpec();
    public RuleFluent.SpecNested<A> withNewSpecLike(RuleSpec item);
    public RuleFluent.SpecNested<A> editSpec();
    public RuleFluent.SpecNested<A> editOrNewSpec();
    public RuleFluent.SpecNested<A> editOrNewSpecLike(RuleSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RuleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,RuleSpecFluent<RuleFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
