package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServiceRoleBindingListBuilder extends ServiceRoleBindingListFluentImpl<ServiceRoleBindingListBuilder> implements VisitableBuilder<ServiceRoleBindingList,ServiceRoleBindingListBuilder>{

    ServiceRoleBindingListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceRoleBindingListBuilder(){
            this(true);
    }
    public ServiceRoleBindingListBuilder(Boolean validationEnabled){
            this(new ServiceRoleBindingList(), validationEnabled);
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingListFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceRoleBindingList(), validationEnabled);
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingListFluent<?> fluent,ServiceRoleBindingList instance){
            this(fluent, instance, true);
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingListFluent<?> fluent,ServiceRoleBindingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingList instance){
            this(instance,true);
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleBindingListBuilder(Validator validator){
            this(new ServiceRoleBindingList(), true);
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingListFluent<?> fluent,ServiceRoleBindingList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServiceRoleBindingListBuilder(ServiceRoleBindingList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ServiceRoleBindingList build(){
            ServiceRoleBindingList buildable = new ServiceRoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceRoleBindingListBuilder that = (ServiceRoleBindingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
