package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServiceRoleListBuilder extends ServiceRoleListFluentImpl<ServiceRoleListBuilder> implements VisitableBuilder<ServiceRoleList,ServiceRoleListBuilder>{

    ServiceRoleListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceRoleListBuilder(){
            this(true);
    }
    public ServiceRoleListBuilder(Boolean validationEnabled){
            this(new ServiceRoleList(), validationEnabled);
    }
    public ServiceRoleListBuilder(ServiceRoleListFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceRoleListBuilder(ServiceRoleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceRoleList(), validationEnabled);
    }
    public ServiceRoleListBuilder(ServiceRoleListFluent<?> fluent,ServiceRoleList instance){
            this(fluent, instance, true);
    }
    public ServiceRoleListBuilder(ServiceRoleListFluent<?> fluent,ServiceRoleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleListBuilder(ServiceRoleList instance){
            this(instance,true);
    }
    public ServiceRoleListBuilder(ServiceRoleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleListBuilder(Validator validator){
            this(new ServiceRoleList(), true);
    }
    public ServiceRoleListBuilder(ServiceRoleListFluent<?> fluent,ServiceRoleList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServiceRoleListBuilder(ServiceRoleList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ServiceRoleList build(){
            ServiceRoleList buildable = new ServiceRoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceRoleListBuilder that = (ServiceRoleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
