
package me.snowdrop.istio.mixer.adapter.bypass;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Any;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "backendAddress",
    "params",
    "sessionBased"
})
@IstioKind(name = "bypass", plural = "bypasses")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class BypassSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("backendAddress")
    @JsonPropertyDescription("")
    private String backendAddress;
    /**
     * 
     * 
     */
    @JsonProperty("params")
    @JsonPropertyDescription("")
    @Valid
    private Any params;
    /**
     * 
     * 
     */
    @JsonProperty("sessionBased")
    @JsonPropertyDescription("")
    private Boolean sessionBased;
    private final static long serialVersionUID = -3608216689652872054L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BypassSpec() {
    }

    /**
     * 
     * @param sessionBased
     * @param params
     * @param backendAddress
     */
    public BypassSpec(String backendAddress, Any params, Boolean sessionBased) {
        super();
        this.backendAddress = backendAddress;
        this.params = params;
        this.sessionBased = sessionBased;
    }

    /**
     * 
     * 
     */
    @JsonProperty("backendAddress")
    public String getBackendAddress() {
        return backendAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("backendAddress")
    public void setBackendAddress(String backendAddress) {
        this.backendAddress = backendAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("params")
    public Any getParams() {
        return params;
    }

    /**
     * 
     * 
     */
    @JsonProperty("params")
    public void setParams(Any params) {
        this.params = params;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sessionBased")
    public Boolean getSessionBased() {
        return sessionBased;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sessionBased")
    public void setSessionBased(Boolean sessionBased) {
        this.sessionBased = sessionBased;
    }

}
