package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CirconusListBuilder extends CirconusListFluentImpl<CirconusListBuilder> implements VisitableBuilder<CirconusList,CirconusListBuilder>{

    CirconusListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CirconusListBuilder(){
            this(true);
    }
    public CirconusListBuilder(Boolean validationEnabled){
            this(new CirconusList(), validationEnabled);
    }
    public CirconusListBuilder(CirconusListFluent<?> fluent){
            this(fluent, true);
    }
    public CirconusListBuilder(CirconusListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CirconusList(), validationEnabled);
    }
    public CirconusListBuilder(CirconusListFluent<?> fluent,CirconusList instance){
            this(fluent, instance, true);
    }
    public CirconusListBuilder(CirconusListFluent<?> fluent,CirconusList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusListBuilder(CirconusList instance){
            this(instance,true);
    }
    public CirconusListBuilder(CirconusList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusListBuilder(Validator validator){
            this(new CirconusList(), true);
    }
    public CirconusListBuilder(CirconusListFluent<?> fluent,CirconusList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CirconusListBuilder(CirconusList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CirconusList build(){
            CirconusList buildable = new CirconusList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CirconusListBuilder that = (CirconusListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
