package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CirconusSpecBuilder extends CirconusSpecFluentImpl<CirconusSpecBuilder> implements VisitableBuilder<CirconusSpec,CirconusSpecBuilder>{

    CirconusSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CirconusSpecBuilder(){
            this(true);
    }
    public CirconusSpecBuilder(Boolean validationEnabled){
            this(new CirconusSpec(), validationEnabled);
    }
    public CirconusSpecBuilder(CirconusSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CirconusSpecBuilder(CirconusSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CirconusSpec(), validationEnabled);
    }
    public CirconusSpecBuilder(CirconusSpecFluent<?> fluent,CirconusSpec instance){
            this(fluent, instance, true);
    }
    public CirconusSpecBuilder(CirconusSpecFluent<?> fluent,CirconusSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withSubmissionInterval(instance.getSubmissionInterval()); 
            fluent.withSubmissionUrl(instance.getSubmissionUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusSpecBuilder(CirconusSpec instance){
            this(instance,true);
    }
    public CirconusSpecBuilder(CirconusSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetrics(instance.getMetrics()); 
            this.withSubmissionInterval(instance.getSubmissionInterval()); 
            this.withSubmissionUrl(instance.getSubmissionUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusSpecBuilder(Validator validator){
            this(new CirconusSpec(), true);
    }
    public CirconusSpecBuilder(CirconusSpecFluent<?> fluent,CirconusSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withSubmissionInterval(instance.getSubmissionInterval()); 
            fluent.withSubmissionUrl(instance.getSubmissionUrl()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CirconusSpecBuilder(CirconusSpec instance,Validator validator){
            this.fluent = this; 
            this.withMetrics(instance.getMetrics()); 
            this.withSubmissionInterval(instance.getSubmissionInterval()); 
            this.withSubmissionUrl(instance.getSubmissionUrl()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CirconusSpec build(){
            CirconusSpec buildable = new CirconusSpec(fluent.getMetrics(),fluent.getSubmissionInterval(),fluent.getSubmissionUrl());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CirconusSpecBuilder that = (CirconusSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
