package me.snowdrop.istio.mixer.adapter.denier;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class DenierBuilder extends DenierFluentImpl<DenierBuilder> implements VisitableBuilder<Denier,DenierBuilder>{

    DenierFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DenierBuilder(){
            this(true);
    }
    public DenierBuilder(Boolean validationEnabled){
            this(new Denier(), validationEnabled);
    }
    public DenierBuilder(DenierFluent<?> fluent){
            this(fluent, true);
    }
    public DenierBuilder(DenierFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Denier(), validationEnabled);
    }
    public DenierBuilder(DenierFluent<?> fluent,Denier instance){
            this(fluent, instance, true);
    }
    public DenierBuilder(DenierFluent<?> fluent,Denier instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public DenierBuilder(Denier instance){
            this(instance,true);
    }
    public DenierBuilder(Denier instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public DenierBuilder(Validator validator){
            this(new Denier(), true);
    }
    public DenierBuilder(DenierFluent<?> fluent,Denier instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public DenierBuilder(Denier instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Denier build(){
            Denier buildable = new Denier(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DenierBuilder that = (DenierBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
